/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriterWithCallback;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileSegmentReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.BulkBlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileSegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IOManagerTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void channelEnumerator() throws IOException {
        TestIOManager ioMan = null;
        try {
            File tempPath = this.temporaryFolder.newFolder();
            String[] tempDirs = new String[]{new File(tempPath, "a").getAbsolutePath(), new File(tempPath, "b").getAbsolutePath(), new File(tempPath, "c").getAbsolutePath(), new File(tempPath, "d").getAbsolutePath(), new File(tempPath, "e").getAbsolutePath()};
            int[] counters = new int[tempDirs.length];
            ioMan = new TestIOManager(tempDirs);
            FileIOChannel.Enumerator enumerator = ioMan.createChannelEnumerator();
            for (int i = 0; i < 3 * tempDirs.length; ++i) {
                FileIOChannel.ID id = enumerator.next();
                File path = id.getPathFile();
                Assert.assertTrue((String)"Channel IDs must name an absolute path.", (boolean)path.isAbsolute());
                Assert.assertFalse((String)"Channel IDs must name a file, not a directory.", (boolean)path.isDirectory());
                Assert.assertTrue((String)"Path is not in the temp directory.", (boolean)tempPath.equals(path.getParentFile().getParentFile().getParentFile()));
                for (int k = 0; k < tempDirs.length; ++k) {
                    if (!path.getParentFile().getParent().equals(tempDirs[k])) continue;
                    int n = k;
                    counters[n] = counters[n] + 1;
                }
            }
            for (int k = 0; k < tempDirs.length; ++k) {
                Assert.assertEquals((long)3L, (long)counters[k]);
            }
        }
        finally {
            if (ioMan != null) {
                ioMan.shutdown();
            }
        }
    }

    private static class TestIOManager
    extends IOManager {
        protected TestIOManager(String[] paths) {
            super(paths);
        }

        public BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID channelID, LinkedBlockingQueue<MemorySegment> returnQueue) {
            throw new UnsupportedOperationException();
        }

        public BlockChannelWriterWithCallback<MemorySegment> createBlockChannelWriter(FileIOChannel.ID channelID, RequestDoneCallback<MemorySegment> callback) {
            throw new UnsupportedOperationException();
        }

        public BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID channelID, LinkedBlockingQueue<MemorySegment> returnQueue) {
            throw new UnsupportedOperationException();
        }

        public BufferFileWriter createBufferFileWriter(FileIOChannel.ID channelID) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BufferFileReader createBufferFileReader(FileIOChannel.ID channelID, RequestDoneCallback<Buffer> callback) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BufferFileSegmentReader createBufferFileSegmentReader(FileIOChannel.ID channelID, RequestDoneCallback<FileSegment> callback) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BulkBlockChannelReader createBulkBlockChannelReader(FileIOChannel.ID channelID, List<MemorySegment> targetSegments, int numBlocks) {
            throw new UnsupportedOperationException();
        }
    }
}

