/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Assert;
import org.junit.Test;

public class EventSerializerTest {
    @Test
    public void testCheckpointBarrierSerialization() throws Exception {
        long id = 2147606770L;
        long timestamp = 2147484875L;
        CheckpointOptions checkpoint = CheckpointOptions.forCheckpointWithDefaultLocation();
        this.testCheckpointBarrierSerialization(id, timestamp, checkpoint);
        byte[] reference = new byte[]{15, 52, 52, 11, 0, 0, 0, 0, -1, -23, -19, 35};
        CheckpointOptions savepoint = new CheckpointOptions(CheckpointType.SAVEPOINT, new CheckpointStorageLocationReference(reference));
        this.testCheckpointBarrierSerialization(id, timestamp, savepoint);
    }

    private void testCheckpointBarrierSerialization(long id, long timestamp, CheckpointOptions options) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        CheckpointBarrier barrier = new CheckpointBarrier(id, timestamp, options);
        ByteBuffer serialized = EventSerializer.toSerializedEvent((AbstractEvent)barrier);
        CheckpointBarrier deserialized = (CheckpointBarrier)EventSerializer.fromSerializedEvent((ByteBuffer)serialized, (ClassLoader)cl);
        Assert.assertFalse((boolean)serialized.hasRemaining());
        Assert.assertEquals((long)id, (long)deserialized.getId());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((Object)options.getCheckpointType(), (Object)deserialized.getCheckpointOptions().getCheckpointType());
        Assert.assertEquals((Object)options.getTargetLocation(), (Object)deserialized.getCheckpointOptions().getTargetLocation());
    }

    @Test
    public void testSerializeDeserializeEvent() throws Exception {
        AbstractEvent[] events;
        for (AbstractEvent evt : events = new AbstractEvent[]{EndOfPartitionEvent.INSTANCE, EndOfSuperstepEvent.INSTANCE, new CheckpointBarrier(1678L, 4623784L, CheckpointOptions.forCheckpointWithDefaultLocation()), new TestTaskEvent(Math.random(), 12361231273L), new CancelCheckpointMarker(287087987329842L)}) {
            ByteBuffer serializedEvent = EventSerializer.toSerializedEvent((AbstractEvent)evt);
            Assert.assertTrue((boolean)serializedEvent.hasRemaining());
            AbstractEvent deserialized = EventSerializer.fromSerializedEvent((ByteBuffer)serializedEvent, (ClassLoader)this.getClass().getClassLoader());
            Assert.assertNotNull((Object)deserialized);
            Assert.assertEquals((Object)evt, (Object)deserialized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsEventPeakOnly() throws Exception {
        Buffer serializedEvent = EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE);
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Assert.assertTrue((boolean)EventSerializer.isEvent((Buffer)serializedEvent, EndOfPartitionEvent.class));
            EndOfPartitionEvent event = (EndOfPartitionEvent)EventSerializer.fromBuffer((Buffer)serializedEvent, (ClassLoader)cl);
            Assert.assertEquals((Object)EndOfPartitionEvent.INSTANCE, (Object)event);
        }
        finally {
            serializedEvent.recycleBuffer();
        }
    }

    @Test
    public void testIsEvent() throws Exception {
        AbstractEvent[] events = new AbstractEvent[]{EndOfPartitionEvent.INSTANCE, EndOfSuperstepEvent.INSTANCE, new CheckpointBarrier(1678L, 4623784L, CheckpointOptions.forCheckpointWithDefaultLocation()), new TestTaskEvent(Math.random(), 12361231273L), new CancelCheckpointMarker(287087987329842L)};
        Class[] expectedClasses = (Class[])Arrays.stream(events).map(Object::getClass).toArray(Class[]::new);
        for (AbstractEvent evt : events) {
            for (Class expectedClass : expectedClasses) {
                if (expectedClass.equals(TestTaskEvent.class)) {
                    try {
                        this.checkIsEvent(evt, expectedClass);
                        Assert.fail((String)"This should fail");
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                    continue;
                }
                if (evt.getClass().equals(expectedClass)) {
                    Assert.assertTrue((boolean)this.checkIsEvent(evt, expectedClass));
                    continue;
                }
                Assert.assertFalse((boolean)this.checkIsEvent(evt, expectedClass));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIsEvent(AbstractEvent event, Class<?> eventClass) throws IOException {
        Buffer serializedEvent = EventSerializer.toBuffer((AbstractEvent)event);
        try {
            boolean bl = EventSerializer.isEvent((Buffer)serializedEvent, eventClass);
            return bl;
        }
        finally {
            serializedEvent.recycleBuffer();
        }
    }
}

