/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.util.Preconditions;

public class BufferBuilderTestUtils {
    public static final int BUFFER_SIZE = 32768;

    public static BufferBuilder createBufferBuilder() {
        return BufferBuilderTestUtils.createBufferBuilder(32768);
    }

    public static BufferBuilder createBufferBuilder(int size) {
        return BufferBuilderTestUtils.createFilledBufferBuilder(size, 0);
    }

    public static BufferBuilder createFilledBufferBuilder(int dataSize) {
        return BufferBuilderTestUtils.createFilledBufferBuilder(32768, dataSize);
    }

    public static BufferBuilder createFilledBufferBuilder(int size, int dataSize) {
        Preconditions.checkArgument((size >= dataSize ? 1 : 0) != 0);
        BufferBuilder bufferBuilder = new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)size), FreeingBufferRecycler.INSTANCE);
        return BufferBuilderTestUtils.fillBufferBuilder(bufferBuilder, dataSize);
    }

    public static BufferBuilder fillBufferBuilder(BufferBuilder bufferBuilder, int dataSize) {
        bufferBuilder.appendAndCommit(ByteBuffer.allocate(dataSize));
        return bufferBuilder;
    }

    public static Buffer buildSingleBuffer(BufferBuilder bufferBuilder) {
        try (BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();){
            Buffer buffer = bufferConsumer.build();
            return buffer;
        }
    }

    public static Buffer buildSingleBuffer(BufferConsumer bufferConsumer) {
        Buffer buffer = bufferConsumer.build();
        bufferConsumer.close();
        return buffer;
    }

    public static BufferConsumer createFilledBufferConsumer(int size, int dataSize) {
        BufferBuilder bufferBuilder = BufferBuilderTestUtils.createFilledBufferBuilder(size, dataSize);
        bufferBuilder.finish();
        return bufferBuilder.createBufferConsumer();
    }

    public static BufferConsumer createFilledBufferConsumer(int dataSize) {
        return BufferBuilderTestUtils.createFilledBufferConsumer(32768, dataSize);
    }

    public static BufferConsumer createEventBufferConsumer(int size) {
        return new BufferConsumer(MemorySegmentFactory.allocateUnpooledSegment((int)size), FreeingBufferRecycler.INSTANCE, false);
    }
}

