/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.Random;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.event.task.IntegerTaskEvent;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Test;

public class NettyMessageSerializationTest {
    public static final boolean RESTORE_OLD_NETTY_BEHAVIOUR = false;
    private final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new NettyMessage.NettyMessageEncoder(), new NettyMessage.NettyMessageDecoder(false)});
    private final Random random = new Random();

    @Test
    public void testEncodeDecode() {
        this.testEncodeDecodeBuffer(false);
        this.testEncodeDecodeBuffer(true);
        IllegalStateException expectedError = new IllegalStateException();
        InputChannelID receiverId = new InputChannelID();
        NettyMessage.ErrorResponse expected = new NettyMessage.ErrorResponse((Throwable)expectedError, receiverId);
        NettyMessage.ErrorResponse actual = this.encodeAndDecode(expected);
        Assert.assertEquals(expected.cause.getClass(), actual.cause.getClass());
        Assert.assertEquals((Object)expected.cause.getMessage(), (Object)actual.cause.getMessage());
        Assert.assertEquals((Object)receiverId, (Object)actual.receiverId);
        expectedError = new IllegalStateException("Illegal illegal illegal");
        receiverId = new InputChannelID();
        expected = new NettyMessage.ErrorResponse((Throwable)expectedError, receiverId);
        actual = this.encodeAndDecode(expected);
        Assert.assertEquals(expected.cause.getClass(), actual.cause.getClass());
        Assert.assertEquals((Object)expected.cause.getMessage(), (Object)actual.cause.getMessage());
        Assert.assertEquals((Object)receiverId, (Object)actual.receiverId);
        expectedError = new IllegalStateException("Illegal illegal illegal");
        NettyMessage.ErrorResponse expected2 = new NettyMessage.ErrorResponse((Throwable)expectedError);
        NettyMessage.ErrorResponse actual2 = this.encodeAndDecode(expected2);
        Assert.assertEquals(expected2.cause.getClass(), actual2.cause.getClass());
        Assert.assertEquals((Object)expected2.cause.getMessage(), (Object)actual2.cause.getMessage());
        Assert.assertNull((Object)actual2.receiverId);
        Assert.assertTrue((boolean)actual2.isFatalError());
        NettyMessage.PartitionRequest expected3 = new NettyMessage.PartitionRequest(new ResultPartitionID(new IntermediateResultPartitionID(), new ExecutionAttemptID()), this.random.nextInt(), new InputChannelID(), this.random.nextInt());
        NettyMessage.PartitionRequest actual3 = this.encodeAndDecode(expected3);
        Assert.assertEquals((Object)expected3.partitionId, (Object)actual3.partitionId);
        Assert.assertEquals((long)expected3.queueIndex, (long)actual3.queueIndex);
        Assert.assertEquals((Object)expected3.receiverId, (Object)actual3.receiverId);
        Assert.assertEquals((long)expected3.credit, (long)actual3.credit);
        expected3 = new NettyMessage.TaskEventRequest((TaskEvent)new IntegerTaskEvent(this.random.nextInt()), new ResultPartitionID(new IntermediateResultPartitionID(), new ExecutionAttemptID()), new InputChannelID());
        actual3 = (NettyMessage.TaskEventRequest)this.encodeAndDecode(expected3);
        Assert.assertEquals((Object)expected3.event, (Object)actual3.event);
        Assert.assertEquals((Object)expected3.partitionId, (Object)actual3.partitionId);
        Assert.assertEquals((Object)expected3.receiverId, (Object)actual3.receiverId);
        expected3 = new NettyMessage.CancelPartitionRequest(new InputChannelID());
        actual3 = (NettyMessage.CancelPartitionRequest)this.encodeAndDecode(expected3);
        Assert.assertEquals((Object)expected3.receiverId, (Object)actual3.receiverId);
        expected3 = new NettyMessage.CloseRequest();
        actual3 = (NettyMessage.CloseRequest)this.encodeAndDecode(expected3);
        Assert.assertEquals(expected3.getClass(), actual3.getClass());
        expected3 = new NettyMessage.AddCredit(new ResultPartitionID(new IntermediateResultPartitionID(), new ExecutionAttemptID()), this.random.nextInt(Integer.MAX_VALUE) + 1, new InputChannelID());
        actual3 = (NettyMessage.AddCredit)this.encodeAndDecode(expected3);
        Assert.assertEquals((Object)expected3.partitionId, (Object)actual3.partitionId);
        Assert.assertEquals((long)expected3.credit, (long)actual3.credit);
        Assert.assertEquals((Object)expected3.receiverId, (Object)actual3.receiverId);
    }

    private void testEncodeDecodeBuffer(boolean testReadOnlyBuffer) {
        NetworkBuffer buffer = new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)1024), FreeingBufferRecycler.INSTANCE);
        for (int i = 0; i < 1024; i += 4) {
            buffer.writeInt(i);
        }
        NetworkBuffer testBuffer = testReadOnlyBuffer ? buffer.readOnlySlice() : buffer;
        NettyMessage.BufferResponse expected = new NettyMessage.BufferResponse((Buffer)testBuffer, this.random.nextInt(), new InputChannelID(), this.random.nextInt());
        NettyMessage.BufferResponse actual = this.encodeAndDecode(expected);
        Assert.assertFalse((boolean)buffer.isRecycled());
        Assert.assertFalse((boolean)testBuffer.isRecycled());
        ByteBuf retainedSlice = actual.getNettyBuffer();
        Assert.assertEquals((long)1L, (long)retainedSlice.refCnt());
        Assert.assertEquals((long)1024L, (long)retainedSlice.readableBytes());
        for (int i = 0; i < 1024; i += 4) {
            Assert.assertEquals((long)i, (long)retainedSlice.readInt());
        }
        actual.releaseBuffer();
        Assert.assertEquals((long)0L, (long)retainedSlice.refCnt());
        Assert.assertTrue((boolean)buffer.isRecycled());
        Assert.assertTrue((boolean)testBuffer.isRecycled());
        Assert.assertEquals((long)expected.sequenceNumber, (long)actual.sequenceNumber);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
        Assert.assertEquals((long)expected.backlog, (long)actual.backlog);
    }

    private <T extends NettyMessage> T encodeAndDecode(T msg) {
        this.channel.writeOutbound(new Object[]{msg});
        ByteBuf encoded = (ByteBuf)this.channel.readOutbound();
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{encoded}));
        return (T)((NettyMessage)this.channel.readInbound());
    }
}

