/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.NoOpResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ResultPartitionTest {
    private static final IOManager ioManager = new IOManagerAsync();

    @AfterClass
    public static void shutdown() {
        ioManager.shutdown();
    }

    @Test
    public void testSendScheduleOrUpdateConsumersMessage() throws Exception {
        ResultPartitionConsumableNotifier notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        ResultPartition partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.PIPELINED, true);
        partition.addBufferConsumer(BufferBuilderTestUtils.createFilledBufferConsumer(32768), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.times((int)1))).notifyPartitionConsumable((JobID)Matchers.eq((Object)partition.getJobId()), (ResultPartitionID)Matchers.eq((Object)partition.getPartitionId()), (TaskActions)Matchers.any(TaskActions.class));
        notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.PIPELINED, false);
        partition.addBufferConsumer(BufferBuilderTestUtils.createFilledBufferConsumer(32768), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.BLOCKING, true);
        partition.addBufferConsumer(BufferBuilderTestUtils.createFilledBufferConsumer(32768), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.BLOCKING, false);
        partition.addBufferConsumer(BufferBuilderTestUtils.createFilledBufferConsumer(32768), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
    }

    @Test
    public void testAddOnFinishedPipelinedPartition() throws Exception {
        this.testAddOnFinishedPartition(ResultPartitionType.PIPELINED);
    }

    @Test
    public void testAddOnFinishedBlockingPartition() throws Exception {
        this.testAddOnFinishedPartition(ResultPartitionType.BLOCKING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAddOnFinishedPartition(ResultPartitionType pipelined) throws Exception {
        BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledBufferConsumer(32768);
        ResultPartitionConsumableNotifier notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        try {
            ResultPartition partition = ResultPartitionTest.createPartition(notifier, pipelined, true);
            partition.finish();
            Mockito.reset((Object[])new ResultPartitionConsumableNotifier[]{notifier});
            partition.addBufferConsumer(bufferConsumer, 0);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            if (!bufferConsumer.isRecycled()) {
                bufferConsumer.close();
                Assert.fail((String)"bufferConsumer not recycled");
            }
            ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        }
    }

    @Test
    public void testAddOnReleasedPipelinedPartition() throws Exception {
        this.testAddOnReleasedPartition(ResultPartitionType.PIPELINED);
    }

    @Test
    public void testAddOnReleasedBlockingPartition() throws Exception {
        this.testAddOnReleasedPartition(ResultPartitionType.BLOCKING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAddOnReleasedPartition(ResultPartitionType pipelined) throws Exception {
        BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledBufferConsumer(32768);
        ResultPartitionConsumableNotifier notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        try {
            ResultPartition partition = ResultPartitionTest.createPartition(notifier, pipelined, true);
            partition.release();
            partition.addBufferConsumer(bufferConsumer, 0);
        }
        finally {
            if (!bufferConsumer.isRecycled()) {
                bufferConsumer.close();
                Assert.fail((String)"bufferConsumer not recycled");
            }
            ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        }
    }

    @Test
    public void testAddOnPipelinedPartition() throws Exception {
        this.testAddOnPartition(ResultPartitionType.PIPELINED);
    }

    @Test
    public void testAddOnBlockingPartition() throws Exception {
        this.testAddOnPartition(ResultPartitionType.BLOCKING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAddOnPartition(ResultPartitionType pipelined) throws Exception {
        ResultPartitionConsumableNotifier notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        ResultPartition partition = ResultPartitionTest.createPartition(notifier, pipelined, true);
        BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledBufferConsumer(32768);
        try {
            partition.addBufferConsumer(bufferConsumer, 0);
            Assert.assertFalse((String)"bufferConsumer should not be recycled (still in the queue)", (boolean)bufferConsumer.isRecycled());
        }
        finally {
            if (!bufferConsumer.isRecycled()) {
                bufferConsumer.close();
            }
            if (pipelined.isPipelined()) {
                ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.times((int)1))).notifyPartitionConsumable((JobID)Matchers.eq((Object)partition.getJobId()), (ResultPartitionID)Matchers.eq((Object)partition.getPartitionId()), (TaskActions)Matchers.any(TaskActions.class));
            }
        }
    }

    @Test
    public void testReleaseMemoryOnBlockingPartition() throws Exception {
        this.testReleaseMemory(ResultPartitionType.BLOCKING);
    }

    @Test
    public void testReleaseMemoryOnPipelinedPartition() throws Exception {
        this.testReleaseMemory(ResultPartitionType.PIPELINED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReleaseMemory(ResultPartitionType resultPartitionType) throws Exception {
        int numAllBuffers = 10;
        NetworkEnvironment network = new NetworkEnvironment(10, 128, 0, 0, 2, 8, true);
        NoOpResultPartitionConsumableNotifier notifier = new NoOpResultPartitionConsumableNotifier();
        ResultPartition resultPartition = ResultPartitionTest.createPartition(notifier, resultPartitionType, false);
        try {
            network.setupPartition(resultPartition);
            for (int i = 0; i < 10; ++i) {
                BufferBuilder bufferBuilder = resultPartition.getBufferPool().requestBufferBuilderBlocking();
                resultPartition.addBufferConsumer(bufferBuilder.createBufferConsumer(), 0);
            }
            resultPartition.finish();
            Assert.assertEquals((long)0L, (long)resultPartition.getBufferPool().getNumberOfAvailableMemorySegments());
            int numLocalBuffers = 4;
            resultPartition.getBufferPool().setNumBuffers(4);
            if (!resultPartitionType.hasBackPressure()) {
                Assert.assertEquals((long)4L, (long)resultPartition.getBufferPool().getNumberOfAvailableMemorySegments());
            } else {
                Assert.assertEquals((long)0L, (long)resultPartition.getBufferPool().getNumberOfAvailableMemorySegments());
            }
        }
        finally {
            resultPartition.release();
            network.shutdown();
        }
    }

    private static ResultPartition createPartition(ResultPartitionConsumableNotifier notifier, ResultPartitionType type, boolean sendScheduleOrUpdateConsumersMessage) {
        return new ResultPartition("TestTask", (TaskActions)Mockito.mock(TaskActions.class), new JobID(), new ResultPartitionID(), type, 1, 1, (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class), notifier, ioManager, sendScheduleOrUpdateConsumersMessage);
    }
}

