/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClient;
import org.apache.flink.runtime.io.network.partition.ProducerFailedException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.util.ExceptionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Tuple2;

public class RemoteInputChannelTest {
    @Test
    public void testExceptionOnReordering() throws Exception {
        SingleInputGate inputGate = (SingleInputGate)Mockito.mock(SingleInputGate.class);
        RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        Buffer buffer = TestBufferFactory.createBuffer(32768);
        inputChannel.onBuffer(buffer.retainBuffer(), 0, -1);
        inputChannel.onBuffer(buffer, 29, -1);
        try {
            inputChannel.getNextBuffer();
            Assert.fail((String)"Did not throw expected exception after enqueuing an out-of-order buffer.");
        }
        catch (Exception expected) {
            Assert.assertFalse((boolean)buffer.isRecycled());
            inputChannel.releaseAllResources();
            Assert.assertTrue((boolean)buffer.isRecycled());
        }
        ((SingleInputGate)Mockito.verify((Object)inputGate, (VerificationMode)Mockito.times((int)2))).notifyChannelNonEmpty((InputChannel)Matchers.eq((Object)inputChannel));
    }

    @Test
    public void testConcurrentOnBufferAndRelease() throws Exception {
        this.testConcurrentReleaseAndSomething(8192, (inputChannel, buffer, j) -> {
            inputChannel.onBuffer(buffer, j.intValue(), -1);
            return null;
        });
    }

    @Test
    public void testConcurrentNotifyBufferAvailableAndRelease() throws Exception {
        this.testConcurrentReleaseAndSomething(1024, (inputChannel, buffer, j) -> inputChannel.notifyBufferAvailable(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentReleaseAndSomething(int numberOfRepetitions, TriFunction<RemoteInputChannel, Buffer, Integer, Object> function) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Buffer buffer = TestBufferFactory.createBuffer(32768);
        try {
            SingleInputGate inputGate = (SingleInputGate)Mockito.mock(SingleInputGate.class);
            for (int i = 0; i < numberOfRepetitions; ++i) {
                RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
                Callable<Void> enqueueTask = () -> {
                    do {
                        for (int j = 0; j < 128; ++j) {
                            Object obj = function.apply(inputChannel, buffer.retainBuffer(), j);
                            if (!(obj instanceof BufferListener.NotificationResult) || obj != BufferListener.NotificationResult.BUFFER_NOT_USED) continue;
                            buffer.recycleBuffer();
                        }
                    } while (!inputChannel.isReleased());
                    return null;
                };
                Callable<Void> releaseTask = () -> {
                    inputChannel.releaseAllResources();
                    return null;
                };
                ArrayList results = Lists.newArrayListWithCapacity((int)2);
                results.add(executor.submit(enqueueTask));
                results.add(executor.submit(releaseTask));
                for (Future result : results) {
                    result.get();
                }
                Assert.assertEquals((String)"Resource leak during concurrent release and notifyBufferAvailable.", (long)0L, (long)inputChannel.getNumberOfQueuedBuffers());
            }
        }
        finally {
            executor.shutdown();
            Assert.assertFalse((boolean)buffer.isRecycled());
            buffer.recycleBuffer();
            Assert.assertTrue((boolean)buffer.isRecycled());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testRetriggerWithoutPartitionRequest() throws Exception {
        Tuple2 backoff = new Tuple2((Object)500, (Object)3000);
        PartitionRequestClient connClient = (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class);
        SingleInputGate inputGate = (SingleInputGate)Mockito.mock(SingleInputGate.class);
        RemoteInputChannel ch = this.createRemoteInputChannel(inputGate, connClient, (Tuple2<Integer, Integer>)backoff);
        ch.retriggerSubpartitionRequest(0);
    }

    @Test
    public void testPartitionRequestExponentialBackoff() throws Exception {
        Tuple2 backoff = new Tuple2((Object)500, (Object)3000);
        int[] expectedDelays = new int[]{(Integer)backoff._1(), 1000, 2000, (Integer)backoff._2()};
        PartitionRequestClient connClient = (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class);
        SingleInputGate inputGate = (SingleInputGate)Mockito.mock(SingleInputGate.class);
        RemoteInputChannel ch = this.createRemoteInputChannel(inputGate, connClient, (Tuple2<Integer, Integer>)backoff);
        ch.requestSubpartition(0);
        ((PartitionRequestClient)Mockito.verify((Object)connClient)).requestSubpartition((ResultPartitionID)Matchers.eq((Object)ch.partitionId), Matchers.eq((int)0), (RemoteInputChannel)Matchers.eq((Object)ch), Matchers.eq((int)0));
        for (int expected : expectedDelays) {
            ch.retriggerSubpartitionRequest(0);
            ((PartitionRequestClient)Mockito.verify((Object)connClient)).requestSubpartition((ResultPartitionID)Matchers.eq((Object)ch.partitionId), Matchers.eq((int)0), (RemoteInputChannel)Matchers.eq((Object)ch), Matchers.eq((int)expected));
        }
        try {
            ch.retriggerSubpartitionRequest(0);
            ch.getNextBuffer();
            Assert.fail((String)"Did not throw expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPartitionRequestSingleBackoff() throws Exception {
        Tuple2 backoff = new Tuple2((Object)500, (Object)500);
        PartitionRequestClient connClient = (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class);
        SingleInputGate inputGate = (SingleInputGate)Mockito.mock(SingleInputGate.class);
        RemoteInputChannel ch = this.createRemoteInputChannel(inputGate, connClient, (Tuple2<Integer, Integer>)backoff);
        ch.requestSubpartition(0);
        ((PartitionRequestClient)Mockito.verify((Object)connClient)).requestSubpartition((ResultPartitionID)Matchers.eq((Object)ch.partitionId), Matchers.eq((int)0), (RemoteInputChannel)Matchers.eq((Object)ch), Matchers.eq((int)0));
        ch.retriggerSubpartitionRequest(0);
        ((PartitionRequestClient)Mockito.verify((Object)connClient)).requestSubpartition((ResultPartitionID)Matchers.eq((Object)ch.partitionId), Matchers.eq((int)0), (RemoteInputChannel)Matchers.eq((Object)ch), ((Integer)Matchers.eq((Object)backoff._1())).intValue());
        try {
            ch.retriggerSubpartitionRequest(0);
            ch.getNextBuffer();
            Assert.fail((String)"Did not throw expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPartitionRequestNoBackoff() throws Exception {
        Tuple2 backoff = new Tuple2((Object)0, (Object)0);
        PartitionRequestClient connClient = (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class);
        SingleInputGate inputGate = (SingleInputGate)Mockito.mock(SingleInputGate.class);
        RemoteInputChannel ch = this.createRemoteInputChannel(inputGate, connClient, (Tuple2<Integer, Integer>)backoff);
        ch.requestSubpartition(0);
        ((PartitionRequestClient)Mockito.verify((Object)connClient)).requestSubpartition((ResultPartitionID)Matchers.eq((Object)ch.partitionId), Matchers.eq((int)0), (RemoteInputChannel)Matchers.eq((Object)ch), Matchers.eq((int)0));
        try {
            ch.retriggerSubpartitionRequest(0);
            ch.getNextBuffer();
            Assert.fail((String)"Did not throw expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testOnFailedPartitionRequest() throws Exception {
        ConnectionManager connectionManager = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        Mockito.when((Object)connectionManager.createPartitionRequestClient((ConnectionID)Matchers.any(ConnectionID.class))).thenReturn(Mockito.mock(PartitionRequestClient.class));
        ResultPartitionID partitionId = new ResultPartitionID();
        SingleInputGate inputGate = (SingleInputGate)Mockito.mock(SingleInputGate.class);
        RemoteInputChannel ch = new RemoteInputChannel(inputGate, 0, partitionId, (ConnectionID)Mockito.mock(ConnectionID.class), connectionManager, UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup());
        ch.onFailedPartitionRequest();
        ((SingleInputGate)Mockito.verify((Object)inputGate)).triggerPartitionStateCheck((ResultPartitionID)Matchers.eq((Object)partitionId));
    }

    @Test(expected=CancelTaskException.class)
    public void testProducerFailedException() throws Exception {
        ConnectionManager connManager = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        Mockito.when((Object)connManager.createPartitionRequestClient((ConnectionID)Matchers.any(ConnectionID.class))).thenReturn(Mockito.mock(PartitionRequestClient.class));
        RemoteInputChannel ch = new RemoteInputChannel((SingleInputGate)Mockito.mock(SingleInputGate.class), 0, new ResultPartitionID(), (ConnectionID)Mockito.mock(ConnectionID.class), connManager, UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup());
        ch.onError((Throwable)new ProducerFailedException((Throwable)new RuntimeException("Expected test exception.")));
        ch.requestSubpartition(0);
        ch.getNextBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAvailableBuffersLessThanRequiredBuffers() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(16, 32);
        int numExclusiveBuffers = 2;
        int numFloatingBuffers = 14;
        SingleInputGate inputGate = this.createSingleInputGate();
        RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(inputChannel.partitionId.getPartitionId(), (InputChannel)inputChannel);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = (BufferPool)Mockito.spy((Object)networkBufferPool.createBufferPool(14, 14));
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 2);
            inputChannel.requestSubpartition(0);
            Buffer exclusiveBuffer = inputChannel.requestBuffer();
            Assert.assertNotNull((Object)exclusiveBuffer);
            int numRecycleFloatingBuffers = 2;
            ArrayDeque<Buffer> floatingBufferQueue = new ArrayDeque<Buffer>(2);
            for (int i = 0; i < 2; ++i) {
                Buffer floatingBuffer = bufferPool.requestBuffer();
                Assert.assertNotNull((Object)floatingBuffer);
                floatingBufferQueue.add(floatingBuffer);
            }
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)2))).requestBuffer();
            inputChannel.onSenderBacklog(14);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)15))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 13 buffers available in the channel", (long)13L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 16 buffers required in the channel", (long)16L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertTrue((boolean)inputChannel.isWaitingForFloatingBuffers());
            inputChannel.onSenderBacklog(16);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)15))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 13 buffers available in the channel", (long)13L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 18 buffers required in the channel", (long)18L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertTrue((boolean)inputChannel.isWaitingForFloatingBuffers());
            exclusiveBuffer.recycleBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)15))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 18 buffers required in the channel", (long)18L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertTrue((boolean)inputChannel.isWaitingForFloatingBuffers());
            ((Buffer)floatingBufferQueue.poll()).recycleBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)15))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 15 buffers available in the channel", (long)15L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 18 buffers required in the channel", (long)18L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertTrue((boolean)inputChannel.isWaitingForFloatingBuffers());
            inputChannel.onSenderBacklog(13);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)15))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 15 buffers available in the channel", (long)15L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 15 buffers required in the channel", (long)15L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertTrue((boolean)inputChannel.isWaitingForFloatingBuffers());
            ((Buffer)floatingBufferQueue.poll()).recycleBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)15))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 15 buffers available in the channel", (long)15L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 15 buffers required in the channel", (long)15L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 1 buffers available in local pool", (long)1L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertFalse((boolean)inputChannel.isWaitingForFloatingBuffers());
            inputChannel.onSenderBacklog(15);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)17))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)2))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 16 buffers available in the channel", (long)16L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 17 buffers required in the channel", (long)17L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertTrue((boolean)inputChannel.isWaitingForFloatingBuffers());
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
                throw throwable;
            }
            this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
        }
        this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAvailableBuffersEqualToRequiredBuffers() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(16, 32);
        int numExclusiveBuffers = 2;
        int numFloatingBuffers = 14;
        SingleInputGate inputGate = this.createSingleInputGate();
        RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(inputChannel.partitionId.getPartitionId(), (InputChannel)inputChannel);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = (BufferPool)Mockito.spy((Object)networkBufferPool.createBufferPool(14, 14));
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 2);
            inputChannel.requestSubpartition(0);
            Buffer exclusiveBuffer = inputChannel.requestBuffer();
            Assert.assertNotNull((Object)exclusiveBuffer);
            Buffer floatingBuffer = bufferPool.requestBuffer();
            Assert.assertNotNull((Object)floatingBuffer);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).requestBuffer();
            inputChannel.onSenderBacklog(12);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)14))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)0))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 14 buffers required in the channel", (long)14L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            floatingBuffer.recycleBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)14))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)0))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 14 buffers required in the channel", (long)14L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 1 buffer available in local pool", (long)1L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            exclusiveBuffer.recycleBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)14))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)0))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 14 buffers required in the channel", (long)14L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 2 buffers available in local pool", (long)2L, (long)bufferPool.getNumberOfAvailableMemorySegments());
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
                throw throwable;
            }
            this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
        }
        this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAvailableBuffersMoreThanRequiredBuffers() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(16, 32);
        int numExclusiveBuffers = 2;
        int numFloatingBuffers = 14;
        SingleInputGate inputGate = this.createSingleInputGate();
        RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(inputChannel.partitionId.getPartitionId(), (InputChannel)inputChannel);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = (BufferPool)Mockito.spy((Object)networkBufferPool.createBufferPool(14, 14));
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 2);
            inputChannel.requestSubpartition(0);
            Buffer exclusiveBuffer = inputChannel.requestBuffer();
            Assert.assertNotNull((Object)exclusiveBuffer);
            Buffer floatingBuffer = bufferPool.requestBuffer();
            Assert.assertNotNull((Object)floatingBuffer);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).requestBuffer();
            inputChannel.onSenderBacklog(12);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)14))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)0))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 14 buffers required in the channel", (long)14L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            inputChannel.onSenderBacklog(10);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)14))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)0))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 12 buffers required in the channel", (long)12L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 0 buffers available in local pool", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            exclusiveBuffer.recycleBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)14))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)0))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 12 buffers required in the channel", (long)12L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 1 buffer available in local pool", (long)1L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            floatingBuffer.recycleBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)14))).requestBuffer();
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)0))).addBufferListener((BufferListener)inputChannel);
            Assert.assertEquals((String)"There should be 14 buffers available in the channel", (long)14L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 12 buffers required in the channel", (long)12L, (long)inputChannel.getNumberOfRequiredBuffers());
            Assert.assertEquals((String)"There should be 2 buffers available in local pool", (long)2L, (long)bufferPool.getNumberOfAvailableMemorySegments());
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
                throw throwable;
            }
            this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
        }
        this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{inputChannel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFairDistributionFloatingBuffers() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(12, 32);
        int numExclusiveBuffers = 2;
        int numFloatingBuffers = 3;
        SingleInputGate inputGate = this.createSingleInputGate();
        RemoteInputChannel channel1 = (RemoteInputChannel)Mockito.spy((Object)this.createRemoteInputChannel(inputGate));
        RemoteInputChannel channel2 = (RemoteInputChannel)Mockito.spy((Object)this.createRemoteInputChannel(inputGate));
        RemoteInputChannel channel3 = (RemoteInputChannel)Mockito.spy((Object)this.createRemoteInputChannel(inputGate));
        inputGate.setInputChannel(channel1.partitionId.getPartitionId(), (InputChannel)channel1);
        inputGate.setInputChannel(channel2.partitionId.getPartitionId(), (InputChannel)channel2);
        inputGate.setInputChannel(channel3.partitionId.getPartitionId(), (InputChannel)channel3);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = (BufferPool)Mockito.spy((Object)networkBufferPool.createBufferPool(3, 3));
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 2);
            channel1.requestSubpartition(0);
            channel2.requestSubpartition(0);
            channel3.requestSubpartition(0);
            ArrayList<Buffer> floatingBuffers = new ArrayList<Buffer>(3);
            for (int i = 0; i < 3; ++i) {
                Buffer buffer = bufferPool.requestBuffer();
                Assert.assertNotNull((Object)buffer);
                floatingBuffers.add(buffer);
            }
            channel1.onSenderBacklog(8);
            channel2.onSenderBacklog(8);
            channel3.onSenderBacklog(8);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)channel1);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)channel2);
            ((BufferPool)Mockito.verify((Object)bufferPool, (VerificationMode)Mockito.times((int)1))).addBufferListener((BufferListener)channel3);
            Assert.assertEquals((String)"There should be 2 buffers available in the channel", (long)2L, (long)channel1.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 2 buffers available in the channel", (long)2L, (long)channel2.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 2 buffers available in the channel", (long)2L, (long)channel3.getNumberOfAvailableBuffers());
            for (Buffer buffer : floatingBuffers) {
                buffer.recycleBuffer();
            }
            ((RemoteInputChannel)Mockito.verify((Object)channel1, (VerificationMode)Mockito.times((int)1))).notifyBufferAvailable((Buffer)Matchers.any(Buffer.class));
            ((RemoteInputChannel)Mockito.verify((Object)channel2, (VerificationMode)Mockito.times((int)1))).notifyBufferAvailable((Buffer)Matchers.any(Buffer.class));
            ((RemoteInputChannel)Mockito.verify((Object)channel3, (VerificationMode)Mockito.times((int)1))).notifyBufferAvailable((Buffer)Matchers.any(Buffer.class));
            Assert.assertEquals((String)"There should be 3 buffers available in the channel", (long)3L, (long)channel1.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 3 buffers available in the channel", (long)3L, (long)channel2.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 3 buffers available in the channel", (long)3L, (long)channel3.getNumberOfAvailableBuffers());
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{channel1, channel2, channel3});
                throw throwable;
            }
            this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{channel1, channel2, channel3});
        }
        this.cleanup(networkBufferPool, null, null, thrown, new InputChannel[]{channel1, channel2, channel3});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailureInNotifyBufferAvailable() throws Exception {
        boolean numExclusiveBuffers = false;
        boolean numFloatingBuffers = true;
        boolean numTotalBuffers = true;
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(1, 32);
        SingleInputGate inputGate = this.createSingleInputGate();
        RemoteInputChannel successfulRemoteIC = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(successfulRemoteIC.partitionId.getPartitionId(), (InputChannel)successfulRemoteIC);
        successfulRemoteIC.requestSubpartition(0);
        RemoteInputChannel failingRemoteIC = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(failingRemoteIC.partitionId.getPartitionId(), (InputChannel)failingRemoteIC);
        Buffer buffer = null;
        Throwable thrown = null;
        try {
            BufferPool bufferPool = networkBufferPool.createBufferPool(1, 1);
            inputGate.setBufferPool(bufferPool);
            buffer = bufferPool.requestBufferBlocking();
            failingRemoteIC.onSenderBacklog(1);
            successfulRemoteIC.onSenderBacklog(1);
            buffer.recycleBuffer();
            buffer = null;
            try {
                failingRemoteIC.checkError();
                Assert.fail((String)"The input channel should have an error based on the failure in RemoteInputChannel#notifyBufferAvailable()");
            }
            catch (IOException e) {
                MatcherAssert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.hasProperty((String)"cause", (Matcher)org.hamcrest.Matchers.isA(IllegalStateException.class)));
            }
            Assert.assertEquals((long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            buffer = successfulRemoteIC.requestBuffer();
            Assert.assertNull((String)"buffer should still remain in failingRemoteIC", (Object)buffer);
            failingRemoteIC.releaseAllResources();
            Assert.assertEquals((long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            buffer = successfulRemoteIC.requestBuffer();
            Assert.assertNotNull((String)"no buffer given to successfulRemoteIC", (Object)buffer);
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, null, buffer, thrown, new InputChannel[]{failingRemoteIC, successfulRemoteIC});
                throw throwable;
            }
            this.cleanup(networkBufferPool, null, buffer, thrown, new InputChannel[]{failingRemoteIC, successfulRemoteIC});
        }
        this.cleanup(networkBufferPool, null, buffer, thrown, new InputChannel[]{failingRemoteIC, successfulRemoteIC});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentOnSenderBacklogAndRelease() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(130, 32);
        int numExclusiveBuffers = 2;
        int numFloatingBuffers = 128;
        ExecutorService executor = Executors.newFixedThreadPool(2);
        SingleInputGate inputGate = this.createSingleInputGate();
        final RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(inputChannel.partitionId.getPartitionId(), (InputChannel)inputChannel);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = networkBufferPool.createBufferPool(128, 128);
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 2);
            inputChannel.requestSubpartition(0);
            Callable<Void> requestBufferTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    do {
                        for (int j = 1; j <= 128; ++j) {
                            inputChannel.onSenderBacklog(j);
                        }
                    } while (!inputChannel.isReleased());
                    return null;
                }
            };
            Callable<Void> releaseTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    inputChannel.releaseAllResources();
                    return null;
                }
            };
            this.submitTasksAndWaitForResults(executor, new Callable[]{requestBufferTask, releaseTask});
            Assert.assertEquals((String)"There should be no buffers available in the channel.", (long)0L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 130 buffers available in local pool.", (long)130L, (long)(bufferPool.getNumberOfAvailableMemorySegments() + networkBufferPool.getNumberOfAvailableMemorySegments()));
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
                throw throwable;
            }
            this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
        }
        this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentOnSenderBacklogAndRecycle() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(248, 32);
        int numExclusiveSegments = 120;
        int numFloatingBuffers = 128;
        int backlog = 128;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        SingleInputGate inputGate = this.createSingleInputGate();
        final RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(inputChannel.partitionId.getPartitionId(), (InputChannel)inputChannel);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = networkBufferPool.createBufferPool(128, 128);
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 120);
            inputChannel.requestSubpartition(0);
            Callable<Void> requestBufferTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (int j = 1; j <= 128; ++j) {
                        inputChannel.onSenderBacklog(j);
                    }
                    return null;
                }
            };
            this.submitTasksAndWaitForResults(executor, new Callable[]{this.recycleExclusiveBufferTask(inputChannel, 120), this.recycleFloatingBufferTask(bufferPool, 128), requestBufferTask});
            Assert.assertEquals((String)("There should be " + inputChannel.getNumberOfRequiredBuffers() + " buffers available in channel."), (long)inputChannel.getNumberOfRequiredBuffers(), (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be no buffers available in local pool.", (long)0L, (long)bufferPool.getNumberOfAvailableMemorySegments());
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
                throw throwable;
            }
            this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
        }
        this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRecycleAndRelease() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(248, 32);
        int numExclusiveSegments = 120;
        int numFloatingBuffers = 128;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        SingleInputGate inputGate = this.createSingleInputGate();
        final RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(inputChannel.partitionId.getPartitionId(), (InputChannel)inputChannel);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = networkBufferPool.createBufferPool(128, 128);
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 120);
            inputChannel.requestSubpartition(0);
            Callable<Void> releaseTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    inputChannel.releaseAllResources();
                    return null;
                }
            };
            this.submitTasksAndWaitForResults(executor, new Callable[]{this.recycleExclusiveBufferTask(inputChannel, 120), this.recycleFloatingBufferTask(bufferPool, 128), releaseTask});
            Assert.assertEquals((String)"There should be no buffers available in the channel.", (long)0L, (long)inputChannel.getNumberOfAvailableBuffers());
            Assert.assertEquals((String)"There should be 128 buffers available in local pool.", (long)128L, (long)bufferPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((String)"There should be 120 buffers available in global pool.", (long)120L, (long)networkBufferPool.getNumberOfAvailableMemorySegments());
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
                throw throwable;
            }
            this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
        }
        this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRecycleAndRelease2() throws Exception {
        int retries = 1000;
        int numExclusiveBuffers = 2;
        int numFloatingBuffers = 2;
        int numTotalBuffers = 4;
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(4, 32);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        SingleInputGate inputGate = this.createSingleInputGate();
        RemoteInputChannel inputChannel = this.createRemoteInputChannel(inputGate);
        inputGate.setInputChannel(inputChannel.partitionId.getPartitionId(), (InputChannel)inputChannel);
        Throwable thrown = null;
        try {
            BufferPool bufferPool = networkBufferPool.createBufferPool(2, 2);
            inputGate.setBufferPool(bufferPool);
            inputGate.assignExclusiveSegments(networkBufferPool, 2);
            inputChannel.requestSubpartition(0);
            Callable<Void> bufferPoolInteractionsTask = () -> {
                for (int i = 0; i < 1000; ++i) {
                    Buffer buffer = bufferPool.requestBufferBlocking();
                    buffer.recycleBuffer();
                }
                return null;
            };
            Callable<Void> channelInteractionsTask = () -> {
                ArrayList<Buffer> exclusiveBuffers = new ArrayList<Buffer>(2);
                ArrayList<Buffer> floatingBuffers = new ArrayList<Buffer>(2);
                try {
                    for (int i = 0; i < 1000; ++i) {
                        Buffer buffer;
                        for (int j = 0; j < 4 && (buffer = inputChannel.requestBuffer()) != null; ++j) {
                            if (buffer.getRecycler() == inputChannel) {
                                exclusiveBuffers.add(buffer);
                                continue;
                            }
                            floatingBuffers.add(buffer);
                        }
                        floatingBuffers.forEach(Buffer::recycleBuffer);
                        floatingBuffers.clear();
                        Assert.assertEquals((long)2L, (long)exclusiveBuffers.size());
                        inputChannel.onSenderBacklog(0);
                        exclusiveBuffers.forEach(Buffer::recycleBuffer);
                        exclusiveBuffers.clear();
                    }
                }
                finally {
                    inputChannel.releaseAllResources();
                }
                return null;
            };
            this.submitTasksAndWaitForResults(executor, new Callable[]{bufferPoolInteractionsTask, channelInteractionsTask});
        }
        catch (Throwable t) {
            try {
                thrown = t;
            }
            catch (Throwable throwable) {
                this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
                throw throwable;
            }
            this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
        }
        this.cleanup(networkBufferPool, executor, null, thrown, new InputChannel[]{inputChannel});
    }

    private SingleInputGate createSingleInputGate() {
        return new SingleInputGate("InputGate", new JobID(), new IntermediateDataSetID(), ResultPartitionType.PIPELINED, 0, 1, (TaskActions)Mockito.mock(TaskActions.class), UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup(), true);
    }

    private RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate) throws IOException, InterruptedException {
        return this.createRemoteInputChannel(inputGate, (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class), (Tuple2<Integer, Integer>)new Tuple2((Object)0, (Object)0));
    }

    private RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate, PartitionRequestClient partitionRequestClient, Tuple2<Integer, Integer> initialAndMaxRequestBackoff) throws IOException, InterruptedException {
        ConnectionManager connectionManager = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        Mockito.when((Object)connectionManager.createPartitionRequestClient((ConnectionID)Matchers.any(ConnectionID.class))).thenReturn((Object)partitionRequestClient);
        return new RemoteInputChannel(inputGate, 0, new ResultPartitionID(), (ConnectionID)Mockito.mock(ConnectionID.class), connectionManager, ((Integer)initialAndMaxRequestBackoff._1()).intValue(), ((Integer)initialAndMaxRequestBackoff._2()).intValue(), UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup());
    }

    private Callable<Void> recycleExclusiveBufferTask(RemoteInputChannel inputChannel, int numExclusiveSegments) {
        final ArrayList<Buffer> exclusiveBuffers = new ArrayList<Buffer>(numExclusiveSegments);
        for (int i = 0; i < numExclusiveSegments; ++i) {
            Buffer buffer = inputChannel.requestBuffer();
            Assert.assertNotNull((Object)buffer);
            exclusiveBuffers.add(buffer);
        }
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Buffer buffer : exclusiveBuffers) {
                    buffer.recycleBuffer();
                }
                return null;
            }
        };
    }

    private Callable<Void> recycleFloatingBufferTask(BufferPool bufferPool, int numFloatingBuffers) throws Exception {
        final ArrayList<Buffer> floatingBuffers = new ArrayList<Buffer>(numFloatingBuffers);
        for (int i = 0; i < numFloatingBuffers; ++i) {
            Buffer buffer = bufferPool.requestBuffer();
            Assert.assertNotNull((Object)buffer);
            floatingBuffers.add(buffer);
        }
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Buffer buffer : floatingBuffers) {
                    buffer.recycleBuffer();
                }
                return null;
            }
        };
    }

    private void submitTasksAndWaitForResults(ExecutorService executor, Callable[] tasks) throws Exception {
        ArrayList results = Lists.newArrayListWithCapacity((int)tasks.length);
        for (Callable task : tasks) {
            results.add(executor.submit(task));
        }
        for (Future result : results) {
            result.get();
        }
    }

    private void cleanup(NetworkBufferPool networkBufferPool, @Nullable ExecutorService executor, @Nullable Buffer buffer, @Nullable Throwable throwable, InputChannel ... inputChannels) throws Exception {
        for (InputChannel inputChannel : inputChannels) {
            try {
                inputChannel.releaseAllResources();
            }
            catch (Throwable tInner) {
                throwable = ExceptionUtils.firstOrSuppressed((Throwable)tInner, (Throwable)throwable);
            }
        }
        if (buffer != null && !buffer.isRecycled()) {
            buffer.recycleBuffer();
        }
        try {
            networkBufferPool.destroyAllBufferPools();
        }
        catch (Throwable tInner) {
            throwable = ExceptionUtils.firstOrSuppressed((Throwable)tInner, (Throwable)throwable);
        }
        try {
            networkBufferPool.destroy();
        }
        catch (Throwable tInner) {
            throwable = ExceptionUtils.firstOrSuppressed((Throwable)tInner, (Throwable)throwable);
        }
        if (executor != null) {
            executor.shutdown();
        }
        if (throwable != null) {
            ExceptionUtils.rethrowException((Throwable)throwable);
        }
    }

    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3) throws Exception;
    }
}

