/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateListener;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestSingleInputGate {
    protected final SingleInputGate inputGate;
    protected final TestInputChannel[] inputChannels;

    public TestSingleInputGate(int numberOfInputChannels) {
        this(numberOfInputChannels, true);
    }

    public TestSingleInputGate(int numberOfInputChannels, boolean initialize) {
        Preconditions.checkArgument((numberOfInputChannels >= 1 ? 1 : 0) != 0);
        SingleInputGate realGate = new SingleInputGate("Test Task Name", new JobID(), new IntermediateDataSetID(), ResultPartitionType.PIPELINED, 0, numberOfInputChannels, (TaskActions)Mockito.mock(TaskActions.class), UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup(), true);
        this.inputGate = (SingleInputGate)Mockito.spy((Object)realGate);
        try {
            Field f = realGate.getClass().getDeclaredField("inputChannelsWithData");
            f.setAccessible(true);
            final ArrayDeque notifications = (ArrayDeque)f.get(realGate);
            ((SingleInputGate)Mockito.doAnswer((Answer)new Answer<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void answer(InvocationOnMock invocation) throws Throwable {
                    invocation.callRealMethod();
                    ArrayDeque arrayDeque = notifications;
                    synchronized (arrayDeque) {
                        if (!notifications.isEmpty()) {
                            InputGateListener listener = (InputGateListener)invocation.getArguments()[0];
                            listener.notifyInputGateNonEmpty((InputGate)TestSingleInputGate.this.inputGate);
                        }
                    }
                    return null;
                }
            }).when((Object)this.inputGate)).registerListener((InputGateListener)Matchers.any(InputGateListener.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.inputChannels = new TestInputChannel[numberOfInputChannels];
        if (initialize) {
            for (int i = 0; i < numberOfInputChannels; ++i) {
                this.inputChannels[i] = new TestInputChannel(this.inputGate, i);
                this.inputGate.setInputChannel(new IntermediateResultPartitionID(), (InputChannel)this.inputChannels[i]);
            }
        }
    }

    public SingleInputGate getInputGate() {
        return this.inputGate;
    }
}

