/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;

@ThreadSafe
public class TestBufferFactory {
    public static final int BUFFER_SIZE = 32768;
    private static final BufferRecycler RECYCLER = FreeingBufferRecycler.INSTANCE;
    private final int bufferSize;
    private final BufferRecycler bufferRecycler;
    private final int poolSize;
    private int numberOfCreatedBuffers = 0;

    public TestBufferFactory(int poolSize, int bufferSize, BufferRecycler bufferRecycler) {
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        this.poolSize = poolSize;
        this.bufferSize = bufferSize;
        this.bufferRecycler = (BufferRecycler)Preconditions.checkNotNull((Object)bufferRecycler);
    }

    public synchronized Buffer create() {
        if (this.numberOfCreatedBuffers >= this.poolSize) {
            return null;
        }
        ++this.numberOfCreatedBuffers;
        return new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)this.bufferSize), this.bufferRecycler);
    }

    public synchronized int getNumberOfCreatedBuffers() {
        return this.numberOfCreatedBuffers;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public static Buffer createBuffer(int dataSize) {
        return TestBufferFactory.createBuffer(32768, dataSize);
    }

    public static Buffer createBuffer(int bufferSize, int dataSize) {
        return new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), RECYCLER, true, dataSize);
    }
}

