/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.util.Preconditions;

@Deprecated
public class TestSubpartitionConsumer
implements Callable<Boolean>,
BufferAvailabilityListener {
    private static final int MAX_SLEEP_TIME_MS = 20;
    private volatile ResultSubpartitionView subpartitionView;
    private BlockingQueue<ResultSubpartitionView> viewQueue = new ArrayBlockingQueue<ResultSubpartitionView>(1);
    private final boolean isSlowConsumer;
    private final TestConsumerCallback callback;
    private final Random random;
    private final AtomicBoolean dataAvailableNotification = new AtomicBoolean(false);

    public TestSubpartitionConsumer(boolean isSlowConsumer, TestConsumerCallback callback) {
        this.isSlowConsumer = isSlowConsumer;
        this.random = isSlowConsumer ? new Random() : null;
        this.callback = (TestConsumerCallback)Preconditions.checkNotNull((Object)callback);
    }

    public void setSubpartitionView(ResultSubpartitionView subpartitionView) {
        this.subpartitionView = (ResultSubpartitionView)Preconditions.checkNotNull((Object)subpartitionView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        try {
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                AtomicBoolean atomicBoolean = this.dataAvailableNotification;
                synchronized (atomicBoolean) {
                    while (!this.dataAvailableNotification.getAndSet(false)) {
                        this.dataAvailableNotification.wait();
                    }
                }
                ResultSubpartition.BufferAndBacklog bufferAndBacklog = this.subpartitionView.getNextBuffer();
                if (this.isSlowConsumer) {
                    Thread.sleep(this.random.nextInt(21));
                }
                if (bufferAndBacklog != null) {
                    if (bufferAndBacklog.isMoreAvailable()) {
                        this.dataAvailableNotification.set(true);
                    }
                    if (bufferAndBacklog.buffer().isBuffer()) {
                        this.callback.onBuffer(bufferAndBacklog.buffer());
                        continue;
                    }
                    AbstractEvent event = EventSerializer.fromBuffer((Buffer)bufferAndBacklog.buffer(), (ClassLoader)this.getClass().getClassLoader());
                    this.callback.onEvent(event);
                    bufferAndBacklog.buffer().recycleBuffer();
                    if (event.getClass() == EndOfPartitionEvent.class) {
                        this.subpartitionView.notifySubpartitionConsumed();
                        Boolean bl = true;
                        return bl;
                    }
                } else {
                    if (!this.subpartitionView.isReleased()) continue;
                    Boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.subpartitionView.releaseAllResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataAvailable() {
        AtomicBoolean atomicBoolean = this.dataAvailableNotification;
        synchronized (atomicBoolean) {
            this.dataAvailableNotification.set(true);
            this.dataAvailableNotification.notifyAll();
        }
    }
}

