/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.checkpoint.TestingRetrievableStateStorageHelper;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraph;
import org.apache.flink.runtime.jobmanager.ZooKeeperSubmittedJobGraphStore;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperResource;
import org.apache.flink.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ZooKeeperSubmittedJobGraphStoreTest
extends TestLogger {
    @Rule
    public ZooKeeperResource zooKeeperResource = new ZooKeeperResource();
    private Configuration configuration;

    @Before
    public void setup() {
        this.configuration = new Configuration();
        this.configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.zooKeeperResource.getConnectString());
    }

    @Test
    public void testJobGraphRemovalFailureAndLockRelease() throws Exception {
        try (CuratorFramework client = ZooKeeperUtils.startCuratorFramework((Configuration)this.configuration);){
            TestingRetrievableStateStorageHelper<SubmittedJobGraph> stateStorage = new TestingRetrievableStateStorageHelper<SubmittedJobGraph>();
            ZooKeeperSubmittedJobGraphStore submittedJobGraphStore = this.createSubmittedJobGraphStore(client, stateStorage);
            submittedJobGraphStore.start(null);
            ZooKeeperSubmittedJobGraphStore otherSubmittedJobGraphStore = this.createSubmittedJobGraphStore(client, stateStorage);
            otherSubmittedJobGraphStore.start(null);
            SubmittedJobGraph jobGraph = new SubmittedJobGraph(new JobGraph(new JobVertex[0]), null);
            submittedJobGraphStore.putJobGraph(jobGraph);
            SubmittedJobGraph recoveredJobGraph = otherSubmittedJobGraphStore.recoverJobGraph(jobGraph.getJobId());
            Assert.assertThat((Object)recoveredJobGraph, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            try {
                otherSubmittedJobGraphStore.removeJobGraph(recoveredJobGraph.getJobId());
                Assert.fail((String)"It should not be possible to remove the JobGraph since the first store still has a lock on it.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            submittedJobGraphStore.stop();
            otherSubmittedJobGraphStore.removeJobGraph(recoveredJobGraph.getJobId());
            Assert.assertThat((Object)otherSubmittedJobGraphStore.recoverJobGraph(recoveredJobGraph.getJobId()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            otherSubmittedJobGraphStore.stop();
        }
    }

    @Nonnull
    public ZooKeeperSubmittedJobGraphStore createSubmittedJobGraphStore(CuratorFramework client, TestingRetrievableStateStorageHelper<SubmittedJobGraph> stateStorage) throws Exception {
        return new ZooKeeperSubmittedJobGraphStore(client, "/foobar", stateStorage);
    }
}

