/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.util.AbstractID;
import org.junit.Assert;
import org.junit.Test;

public class CoLocationConstraintTest {
    @Test
    public void testCreateConstraints() {
        try {
            JobVertexID id1 = new JobVertexID();
            JobVertexID id2 = new JobVertexID();
            JobVertex vertex1 = new JobVertex("vertex1", id1);
            vertex1.setParallelism(2);
            JobVertex vertex2 = new JobVertex("vertex2", id2);
            vertex2.setParallelism(3);
            CoLocationGroup group = new CoLocationGroup(new JobVertex[]{vertex1, vertex2});
            AbstractID groupId = group.getId();
            Assert.assertNotNull((Object)groupId);
            CoLocationConstraint constraint1 = group.getLocationConstraint(0);
            CoLocationConstraint constraint2 = group.getLocationConstraint(1);
            CoLocationConstraint constraint3 = group.getLocationConstraint(2);
            Assert.assertFalse((constraint1 == constraint2 ? 1 : 0) != 0);
            Assert.assertFalse((constraint1 == constraint3 ? 1 : 0) != 0);
            Assert.assertFalse((constraint2 == constraint3 ? 1 : 0) != 0);
            Assert.assertEquals((Object)groupId, (Object)constraint1.getGroupId());
            Assert.assertEquals((Object)groupId, (Object)constraint2.getGroupId());
            Assert.assertEquals((Object)groupId, (Object)constraint3.getGroupId());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAssignSlotAndLockLocation() {
        try {
            JobID jid = new JobID();
            JobVertex vertex = new JobVertex("vertex");
            vertex.setParallelism(1);
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{vertex.getID()});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            CoLocationGroup constraintGroup = new CoLocationGroup(new JobVertex[]{vertex});
            CoLocationConstraint constraint = constraintGroup.getLocationConstraint(0);
            Assert.assertFalse((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            Instance instance1 = SchedulerTestUtils.getRandomInstance(2);
            Instance instance2 = SchedulerTestUtils.getRandomInstance(2);
            SharedSlot slot1_1 = instance1.allocateSharedSlot(assignment);
            SharedSlot slot1_2 = instance1.allocateSharedSlot(assignment);
            SharedSlot slot2_1 = instance2.allocateSharedSlot(assignment);
            SharedSlot slot2_2 = instance2.allocateSharedSlot(assignment);
            Assert.assertFalse((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            constraint.setSharedSlot(slot1_1);
            Assert.assertFalse((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            try {
                constraint.getLocation();
                Assert.fail((String)"should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception, should be IllegalStateException");
            }
            constraint.setSharedSlot(slot2_1);
            Assert.assertTrue((boolean)slot1_1.isReleased());
            Assert.assertFalse((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            constraint.setSharedSlot(slot2_1);
            Assert.assertFalse((boolean)slot2_1.isReleased());
            Assert.assertFalse((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            constraint.lockLocation();
            Assert.assertTrue((boolean)constraint.isAssigned());
            Assert.assertTrue((boolean)constraint.isAssignedAndAlive());
            Assert.assertEquals((Object)instance2.getTaskManagerLocation(), (Object)constraint.getLocation());
            slot2_1.releaseSlot();
            Assert.assertTrue((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            Assert.assertEquals((Object)instance2.getTaskManagerLocation(), (Object)constraint.getLocation());
            try {
                constraint.setSharedSlot(slot1_2);
                Assert.fail((String)"should throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception, should be IllegalArgumentException");
            }
            constraint.setSharedSlot(slot2_2);
            Assert.assertTrue((boolean)constraint.isAssigned());
            Assert.assertTrue((boolean)constraint.isAssignedAndAlive());
            Assert.assertEquals((Object)instance2.getTaskManagerLocation(), (Object)constraint.getLocation());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

