/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestBase;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class SchedulerSlotSharingTest
extends SchedulerTestBase {
    @Test
    public void scheduleSingleVertexType() {
        try {
            JobVertexID jid1 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1});
            ResourceID tm1ResourceId = this.testingSlotProvider.addTaskManager(2).getResourceID();
            this.testingSlotProvider.addTaskManager(2);
            LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1, s2, s3, s4));
            try {
                this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            s3.releaseSlot();
            LogicalSlot s5 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s5);
            s1.releaseSlot();
            s2.releaseSlot();
            s4.releaseSlot();
            LogicalSlot s6 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 5, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s7 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 6, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s8 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 7, 8, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s6);
            Assert.assertNotNull((Object)s7);
            Assert.assertNotNull((Object)s8);
            int c = 0;
            c += s5.getTaskManagerLocation().getResourceID().equals((Object)tm1ResourceId) ? 1 : -1;
            c += s6.getTaskManagerLocation().getResourceID().equals((Object)tm1ResourceId) ? 1 : -1;
            c += s7.getTaskManagerLocation().getResourceID().equals((Object)tm1ResourceId) ? 1 : -1;
            Assert.assertEquals((long)0L, (long)(c += s8.getTaskManagerLocation().getResourceID().equals((Object)tm1ResourceId) ? 1 : -1));
            s5.releaseSlot();
            s6.releaseSlot();
            s7.releaseSlot();
            s8.releaseSlot();
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)8L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateSlotWithSharing() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
        this.testingSlotProvider.addTaskManager(2);
        this.testingSlotProvider.addTaskManager(2);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertNotNull((Object)s1);
        Assert.assertNotNull((Object)s2);
        Assert.assertNotNull((Object)s3);
        Assert.assertNotNull((Object)s4);
        Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1, s2, s3, s4));
        try {
            this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.fail((String)"Scheduler accepted too many tasks at the same time");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception.");
        }
        LogicalSlot s1_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s2_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s3_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s4_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertNotNull((Object)s1_2);
        Assert.assertNotNull((Object)s2_2);
        Assert.assertNotNull((Object)s3_2);
        Assert.assertNotNull((Object)s4_2);
        try {
            this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 4, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.fail((String)"Scheduler accepted too many tasks at the same time");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception.");
        }
        s1.releaseSlot();
        s4.releaseSlot();
        Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
        try {
            this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 4, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.fail((String)"Scheduler accepted too many tasks at the same time");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception.");
        }
        LogicalSlot s5 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertNotNull((Object)s5);
        Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
        Assert.assertEquals((long)1L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
        s2_2.releaseSlot();
        LogicalSlot s5_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 4, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertNotNull((Object)s5_2);
        s2.releaseSlot();
        s3.releaseSlot();
        s5.releaseSlot();
        s1_2.releaseSlot();
        s3_2.releaseSlot();
        s4_2.releaseSlot();
        s5_2.releaseSlot();
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
        Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)10L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
    }

    @Test
    public void allocateSlotWithIntermediateTotallyEmptySharingGroup() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            this.testingSlotProvider.addTaskManager(2);
            this.testingSlotProvider.addTaskManager(2);
            LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
            s1.releaseSlot();
            s2.releaseSlot();
            s3.releaseSlot();
            s4.releaseSlot();
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
            LogicalSlot s1_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
            s1_2.releaseSlot();
            s2_2.releaseSlot();
            s3_2.releaseSlot();
            s4_2.releaseSlot();
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)8L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateSlotWithTemporarilyEmptyVertexGroup() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3});
            this.testingSlotProvider.addTaskManager(2);
            this.testingSlotProvider.addTaskManager(2);
            LogicalSlot s1_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1_1);
            Assert.assertNotNull((Object)s2_1);
            Assert.assertNotNull((Object)s3_1);
            Assert.assertNotNull((Object)s4_1);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1_1, s2_1, s3_1, s4_1));
            LogicalSlot s1_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 7, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 7, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 7, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 7, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1_2);
            Assert.assertNotNull((Object)s2_2);
            Assert.assertNotNull((Object)s3_2);
            Assert.assertNotNull((Object)s4_2);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1_2, s2_2, s3_2, s4_2));
            LogicalSlot s1_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1_3);
            Assert.assertNotNull((Object)s2_3);
            Assert.assertNotNull((Object)s3_3);
            Assert.assertNotNull((Object)s4_3);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1_3, s2_3, s3_3, s4_3));
            try {
                this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            s1_2.releaseSlot();
            s2_2.releaseSlot();
            s3_2.releaseSlot();
            s4_2.releaseSlot();
            LogicalSlot s5_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 5, 7, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s6_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 6, 7, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s7_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 7, 7, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s5_2);
            Assert.assertNotNull((Object)s6_2);
            Assert.assertNotNull((Object)s7_2);
            s1_1.releaseSlot();
            s2_1.releaseSlot();
            s3_1.releaseSlot();
            s4_1.releaseSlot();
            s5_2.releaseSlot();
            s6_2.releaseSlot();
            s7_2.releaseSlot();
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
            s1_3.releaseSlot();
            s2_3.releaseSlot();
            s3_3.releaseSlot();
            s4_3.releaseSlot();
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)15L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateSlotWithTemporarilyEmptyVertexGroup2() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            this.testingSlotProvider.addTaskManager(2);
            LogicalSlot s1_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 2, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 2, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 2, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1_1);
            Assert.assertNotNull((Object)s2_1);
            Assert.assertNotNull((Object)s2_2);
            Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((long)1L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
            s2_1.releaseSlot();
            s2_2.releaseSlot();
            LogicalSlot sx = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)sx);
            Assert.assertEquals((long)1L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid1));
            Assert.assertEquals((long)1L, (long)this.testingSlotProvider.getNumberOfAvailableSlotsForGroup(sharingGroup, jid2));
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleMixedSharingAndNonSharing() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jidA = new JobVertexID();
            JobVertexID jidB = new JobVertexID();
            JobVertexID jidC = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            this.testingSlotProvider.addTaskManager(3);
            this.testingSlotProvider.addTaskManager(2);
            LogicalSlot sA2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidA, 1, 2, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot sA1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidA, 0, 2, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)sA1);
            Assert.assertNotNull((Object)sA2);
            LogicalSlot s1_0 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s1_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_0 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1_0);
            Assert.assertNotNull((Object)s1_1);
            Assert.assertNotNull((Object)s2_0);
            Assert.assertNotNull((Object)s2_1);
            LogicalSlot sB1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 1, 3, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)sB1);
            try {
                this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            try {
                this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            try {
                this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 0, 3, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            try {
                this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidC, 0, 1, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            sA1.releaseSlot();
            LogicalSlot s1_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1_2);
            Assert.assertNotNull((Object)s2_2);
            s1_0.releaseSlot();
            s1_1.releaseSlot();
            s2_0.releaseSlot();
            Assert.assertEquals((long)1L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
            LogicalSlot sB0 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 0, 3, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)sB0);
            s2_1.releaseSlot();
            LogicalSlot sB2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 2, 3, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)sB2);
            sA2.releaseSlot();
            LogicalSlot s1_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1_3);
            Assert.assertNotNull((Object)s2_3);
            s1_2.releaseSlot();
            s2_2.releaseSlot();
            s1_3.releaseSlot();
            s2_3.releaseSlot();
            LogicalSlot sC0 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidC, 1, 2, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot sC1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidC, 0, 2, null)), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)sC0);
            Assert.assertNotNull((Object)sC1);
            sB0.releaseSlot();
            sB1.releaseSlot();
            sB2.releaseSlot();
            sC0.releaseSlot();
            sC1.releaseSlot();
            Assert.assertEquals((long)5L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)15L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLocalizedAssignment1() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(2);
            TaskManagerLocation loc2 = this.testingSlotProvider.addTaskManager(2);
            LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((Object)loc1, (Object)s1.getTaskManagerLocation());
            Assert.assertEquals((Object)loc2, (Object)s2.getTaskManagerLocation());
            LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((Object)loc1, (Object)s3.getTaskManagerLocation());
            Assert.assertEquals((Object)loc2, (Object)s4.getTaskManagerLocation());
            Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLocalizedAssignment2() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(2);
            TaskManagerLocation loc2 = this.testingSlotProvider.addTaskManager(2);
            LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((Object)loc1, (Object)s1.getTaskManagerLocation());
            Assert.assertEquals((Object)loc1, (Object)s2.getTaskManagerLocation());
            LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
            LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((Object)loc2, (Object)s3.getTaskManagerLocation());
            Assert.assertEquals((Object)loc2, (Object)s4.getTaskManagerLocation());
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLocalizedAssignment3() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(2);
            TaskManagerLocation loc2 = this.testingSlotProvider.addTaskManager(2);
            LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 4, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 4, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s5 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 3, 4, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            LogicalSlot s6 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 4, 4, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), false, SchedulerSlotSharingTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertNotNull((Object)s5);
            Assert.assertNotNull((Object)s6);
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfSlots(sharingGroup));
            Assert.assertEquals((Object)loc1, (Object)s1.getTaskManagerLocation());
            Assert.assertEquals((Object)loc1, (Object)s2.getTaskManagerLocation());
            Assert.assertEquals((Object)loc1, (Object)s3.getTaskManagerLocation());
            Assert.assertEquals((Object)loc1, (Object)s4.getTaskManagerLocation());
            Assert.assertEquals((Object)loc2, (Object)s5.getTaskManagerLocation());
            Assert.assertEquals((Object)loc2, (Object)s6.getTaskManagerLocation());
            Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
            Assert.assertTrue((2 == this.testingSlotProvider.getNumberOfNonLocalizedAssignments() || 2 == this.testingSlotProvider.getNumberOfHostLocalizedAssignments() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSequentialAllocateAndRelease() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            JobVertexID jid4 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3, jid4});
            this.testingSlotProvider.addTaskManager(4);
            LogicalSlot slot_1_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_1_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_2_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_2_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_1_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_1_4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_2_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_2_4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            slot_1_1.releaseSlot();
            slot_1_2.releaseSlot();
            slot_1_3.releaseSlot();
            slot_1_4.releaseSlot();
            slot_2_1.releaseSlot();
            slot_2_2.releaseSlot();
            slot_2_3.releaseSlot();
            slot_2_4.releaseSlot();
            LogicalSlot slot_4_1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_4_2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_4_3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot slot_4_4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            slot_3.releaseSlot();
            slot_4_1.releaseSlot();
            slot_4_2.releaseSlot();
            slot_4_3.releaseSlot();
            slot_4_4.releaseSlot();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentAllocateAndRelease() {
        final ExecutorService executor = Executors.newFixedThreadPool(20);
        try {
            this.testingSlotProvider.addTaskManager(4);
            for (int run = 0; run < 50; ++run) {
                final JobVertexID jid1 = new JobVertexID();
                final JobVertexID jid2 = new JobVertexID();
                final JobVertexID jid3 = new JobVertexID();
                final JobVertexID jid4 = new JobVertexID();
                final SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3, jid4});
                final AtomicInteger enumerator1 = new AtomicInteger();
                final AtomicInteger enumerator2 = new AtomicInteger();
                final AtomicBoolean flag3 = new AtomicBoolean();
                final AtomicInteger enumerator4 = new AtomicInteger();
                final Random rnd = new Random();
                final AtomicBoolean failed = new AtomicBoolean(false);
                final AtomicInteger completed = new AtomicInteger();
                final Runnable deploy4 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                LogicalSlot slot = (LogicalSlot)SchedulerSlotSharingTest.this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, enumerator4.getAndIncrement(), 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                final Runnable deploy3 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                if (!flag3.compareAndSet(false, true)) break block5;
                                LogicalSlot slot = (LogicalSlot)SchedulerSlotSharingTest.this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                                CommonTestUtils.sleepUninterruptibly(5L);
                                executor.execute(deploy4);
                                executor.execute(deploy4);
                                executor.execute(deploy4);
                                executor.execute(deploy4);
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                final Runnable deploy2 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                LogicalSlot slot = (LogicalSlot)SchedulerSlotSharingTest.this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, enumerator2.getAndIncrement(), 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                executor.execute(deploy3);
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                final Runnable deploy1 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                LogicalSlot slot = (LogicalSlot)SchedulerSlotSharingTest.this.testingSlotProvider.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, enumerator1.getAndIncrement(), 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                executor.execute(deploy2);
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                Runnable deploy0 = new Runnable(){

                    @Override
                    public void run() {
                        CommonTestUtils.sleepUninterruptibly(rnd.nextInt(10));
                        executor.execute(deploy1);
                    }
                };
                executor.execute(deploy0);
                executor.execute(deploy0);
                executor.execute(deploy0);
                executor.execute(deploy0);
                AtomicInteger atomicInteger = completed;
                synchronized (atomicInteger) {
                    while (!failed.get() && completed.get() < 13) {
                        completed.wait(1000L);
                    }
                }
                Assert.assertFalse((String)"Thread failed", (boolean)failed.get());
                while (this.testingSlotProvider.getNumberOfAvailableSlots() < 4) {
                    CommonTestUtils.sleepUninterruptibly(5L);
                }
                Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
                Assert.assertEquals((long)(13 * (run + 1)), (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDopIncreases() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            JobVertexID jid4 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3, jid4});
            Scheduler scheduler = new Scheduler((Executor)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(4));
            LogicalSlot s1 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s2 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.assertEquals((Object)s1.getTaskManagerLocation(), (Object)s2.getTaskManagerLocation());
            Assert.assertEquals((long)3L, (long)scheduler.getNumberOfAvailableSlots());
            LogicalSlot s3_0 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3_1 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 1, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_0 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 0, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_1 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 1, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            s1.releaseSlot();
            s2.releaseSlot();
            LogicalSlot s3_2 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 2, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s3_3 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 3, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_2 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 2, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            LogicalSlot s4_3 = (LogicalSlot)scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 3, 4, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            try {
                scheduler.allocateSlot(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 4, 5, sharingGroup), sharingGroup.getSlotSharingGroupId()), false, SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
                Assert.fail((String)"should throw an exception");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
            }
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            s3_0.releaseSlot();
            s3_1.releaseSlot();
            s3_2.releaseSlot();
            s3_3.releaseSlot();
            s4_0.releaseSlot();
            s4_1.releaseSlot();
            s4_2.releaseSlot();
            s4_3.releaseSlot();
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static SlotProfile slotProfileForLocation(TaskManagerLocation location) {
        return new SlotProfile(ResourceProfile.UNKNOWN, Collections.singletonList(location), Collections.emptyList());
    }
}

