/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SchedulerTest
extends TestLogger {
    @Test
    public void testAddAndRemoveInstance() {
        Scheduler scheduler = new Scheduler((Executor)TestingUtils.defaultExecutionContext());
        Instance i1 = SchedulerTestUtils.getRandomInstance(2);
        Instance i2 = SchedulerTestUtils.getRandomInstance(2);
        Instance i3 = SchedulerTestUtils.getRandomInstance(2);
        Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
        scheduler.newInstanceAvailable(i1);
        Assert.assertEquals((long)1L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
        scheduler.newInstanceAvailable(i2);
        Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
        scheduler.newInstanceAvailable(i3);
        Assert.assertEquals((long)3L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)6L, (long)scheduler.getNumberOfAvailableSlots());
        try {
            scheduler.newInstanceAvailable(i2);
            Assert.fail((String)"Scheduler accepted instance twice");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)6L, (long)scheduler.getNumberOfAvailableSlots());
        scheduler.instanceDied(i2);
        Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
        try {
            scheduler.newInstanceAvailable(i2);
            Assert.fail((String)"Scheduler accepted dead instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        scheduler.instanceDied(i1);
        Assert.assertEquals((long)1L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
        scheduler.instanceDied(i3);
        Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableInstances());
        Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
        Assert.assertFalse((boolean)i1.isAlive());
        Assert.assertFalse((boolean)i2.isAlive());
        Assert.assertFalse((boolean)i3.isAlive());
    }

    @Test
    public void testSlotAllocationTimeout() throws Exception {
        Scheduler scheduler = new Scheduler((Executor)TestingUtils.defaultExecutor());
        ExecutionGraph executionGraph = ExecutionGraphTestUtils.createSimpleTestGraph();
        Map registeredExecutions = executionGraph.getRegisteredExecutions();
        Assert.assertThat(registeredExecutions.values(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Execution execution = (Execution)registeredExecutions.values().iterator().next();
        CompletableFuture slotFuture = scheduler.allocateSlot(new ScheduledUnit(execution), true, SlotProfile.noRequirements(), Time.milliseconds((long)1L));
        try {
            slotFuture.get();
        }
        catch (ExecutionException ee) {
            Assert.assertThat((Object)ExceptionUtils.stripExecutionException((Throwable)ee), (Matcher)Matchers.instanceOf(TimeoutException.class));
        }
    }
}

