/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobNotFinishedException;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.jobmaster.factories.UnregisteredJobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JobManagerRunnerTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static Configuration configuration;
    private static TestingRpcService rpcService;
    private static BlobServer blobServer;
    private static HeartbeatServices heartbeatServices;
    private static JobManagerSharedServices jobManagerSharedServices;
    private static JobGraph jobGraph;
    private static ArchivedExecutionGraph archivedExecutionGraph;
    private TestingHighAvailabilityServices haServices;
    private TestingFatalErrorHandler fatalErrorHandler;

    @BeforeClass
    public static void setupClass() throws Exception {
        configuration = new Configuration();
        rpcService = new TestingRpcService();
        configuration.setString(BlobServerOptions.STORAGE_DIRECTORY, temporaryFolder.newFolder().getAbsolutePath());
        blobServer = new BlobServer(configuration, (BlobStore)new VoidBlobStore());
        jobManagerSharedServices = JobManagerSharedServices.fromConfiguration((Configuration)configuration, (BlobServer)blobServer);
        JobVertex jobVertex = new JobVertex("Test vertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setJobID(jobGraph.getJobID()).setState(JobStatus.FINISHED).build();
    }

    @Before
    public void setup() {
        this.haServices = new TestingHighAvailabilityServices();
        this.haServices.setJobMasterLeaderElectionService(jobGraph.getJobID(), new TestingLeaderElectionService());
        this.haServices.setResourceManagerLeaderRetriever((LeaderRetrievalService)new SettableLeaderRetrievalService());
        this.haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory());
        this.fatalErrorHandler = new TestingFatalErrorHandler();
    }

    @After
    public void tearDown() throws Exception {
        this.fatalErrorHandler.rethrowError();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (jobManagerSharedServices != null) {
            jobManagerSharedServices.shutdown();
        }
        if (blobServer != null) {
            blobServer.close();
        }
        if (rpcService != null) {
            rpcService.stopService();
        }
    }

    @Test
    public void testJobCompletion() throws Exception {
        try (JobManagerRunner jobManagerRunner = this.createJobManagerRunner();){
            jobManagerRunner.start();
            CompletableFuture resultFuture = jobManagerRunner.getResultFuture();
            Assert.assertThat((Object)resultFuture.isDone(), (Matcher)Matchers.is((Object)false));
            jobManagerRunner.jobReachedGloballyTerminalState(archivedExecutionGraph);
            Assert.assertThat(resultFuture.get(), (Matcher)Matchers.is((Object)archivedExecutionGraph));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobFinishedByOther() throws Exception {
        try (JobManagerRunner jobManagerRunner = this.createJobManagerRunner();){
            jobManagerRunner.start();
            CompletableFuture resultFuture = jobManagerRunner.getResultFuture();
            Assert.assertThat((Object)resultFuture.isDone(), (Matcher)Matchers.is((Object)false));
            jobManagerRunner.jobFinishedByOther();
            try {
                resultFuture.get();
                Assert.fail((String)"Should have failed.");
            }
            catch (ExecutionException ee) {
                Assert.assertThat((Object)ExceptionUtils.stripExecutionException((Throwable)ee), (Matcher)Matchers.instanceOf(JobNotFinishedException.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutDown() throws Exception {
        try (JobManagerRunner jobManagerRunner = this.createJobManagerRunner();){
            jobManagerRunner.start();
            CompletableFuture resultFuture = jobManagerRunner.getResultFuture();
            Assert.assertThat((Object)resultFuture.isDone(), (Matcher)Matchers.is((Object)false));
            jobManagerRunner.closeAsync();
            try {
                resultFuture.get();
                Assert.fail((String)"Should have failed.");
            }
            catch (ExecutionException ee) {
                Assert.assertThat((Object)ExceptionUtils.stripExecutionException((Throwable)ee), (Matcher)Matchers.instanceOf(JobNotFinishedException.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerRegistration() throws Exception {
        try (JobManagerRunner jobManagerRunner = this.createJobManagerRunner();){
            jobManagerRunner.start();
            LibraryCacheManager libraryCacheManager = jobManagerSharedServices.getLibraryCacheManager();
            JobID jobID = jobGraph.getJobID();
            Assert.assertThat((Object)libraryCacheManager.hasClassLoader(jobID), (Matcher)Matchers.is((Object)true));
            jobManagerRunner.close();
            Assert.assertThat((Object)libraryCacheManager.hasClassLoader(jobID), (Matcher)Matchers.is((Object)false));
        }
    }

    @Nonnull
    private JobManagerRunner createJobManagerRunner() throws Exception {
        return new JobManagerRunner(ResourceID.generate(), jobGraph, configuration, (RpcService)rpcService, (HighAvailabilityServices)this.haServices, heartbeatServices, blobServer, jobManagerSharedServices, (JobManagerJobMetricGroupFactory)UnregisteredJobManagerJobMetricGroupFactory.INSTANCE, (FatalErrorHandler)this.fatalErrorHandler);
    }

    static {
        heartbeatServices = new HeartbeatServices(1000L, 1000L);
    }
}

