/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class AllocatedSlotsTest
extends TestLogger {
    @Test
    public void testOperations() throws Exception {
        SlotPool.AllocatedSlots allocatedSlots = new SlotPool.AllocatedSlots();
        AllocationID allocation1 = new AllocationID();
        SlotRequestId slotRequestID = new SlotRequestId();
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        ResourceID resource1 = taskManagerLocation.getResourceID();
        AllocatedSlot slot1 = this.createSlot(allocation1, taskManagerLocation);
        allocatedSlots.add(slotRequestID, slot1);
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.size());
        AllocationID allocation2 = new AllocationID();
        SlotRequestId slotRequestID2 = new SlotRequestId();
        AllocatedSlot slot2 = this.createSlot(allocation2, taskManagerLocation);
        allocatedSlots.add(slotRequestID2, slot2);
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertEquals((Object)slot2, (Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((long)2L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)2L, (long)allocatedSlots.size());
        AllocationID allocation3 = new AllocationID();
        SlotRequestId slotRequestID3 = new SlotRequestId();
        LocalTaskManagerLocation taskManagerLocation2 = new LocalTaskManagerLocation();
        ResourceID resource2 = taskManagerLocation2.getResourceID();
        AllocatedSlot slot3 = this.createSlot(allocation3, taskManagerLocation2);
        allocatedSlots.add(slotRequestID3, slot3);
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot3.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource2));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertEquals((Object)slot2, (Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((Object)slot3, (Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)2L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)3L, (long)allocatedSlots.size());
        allocatedSlots.remove(slot2.getAllocationId());
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot3.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource2));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertNull((Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((Object)slot3, (Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)2L, (long)allocatedSlots.size());
        allocatedSlots.remove(slot1.getAllocationId());
        Assert.assertFalse((boolean)allocatedSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot3.getAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.containResource(resource1));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource2));
        Assert.assertNull((Object)allocatedSlots.get(allocation1));
        Assert.assertNull((Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((Object)slot3, (Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)0L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.size());
        allocatedSlots.remove(slot3.getAllocationId());
        Assert.assertFalse((boolean)allocatedSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot2.getAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot3.getAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.containResource(resource1));
        Assert.assertFalse((boolean)allocatedSlots.containResource(resource2));
        Assert.assertNull((Object)allocatedSlots.get(allocation1));
        Assert.assertNull((Object)allocatedSlots.get(allocation2));
        Assert.assertNull((Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)0L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)0L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)0L, (long)allocatedSlots.size());
    }

    private AllocatedSlot createSlot(AllocationID allocationId, TaskManagerLocation taskManagerLocation) {
        return new AllocatedSlot(allocationId, taskManagerLocation, 0, ResourceProfile.UNKNOWN, (TaskManagerGateway)new SimpleAckingTaskManagerGateway());
    }
}

