/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolGateway;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.junit.rules.ExternalResource;

public class SlotPoolResource
extends ExternalResource {
    @Nonnull
    private final RpcService rpcService;
    @Nonnull
    private final SchedulingStrategy schedulingStrategy;
    private SlotPool slotPool;
    private SlotPoolGateway slotPoolGateway;
    private TestingResourceManagerGateway testingResourceManagerGateway;

    public SlotPoolResource(@Nonnull RpcService rpcService, @Nonnull SchedulingStrategy schedulingStrategy) {
        this.rpcService = rpcService;
        this.schedulingStrategy = schedulingStrategy;
        this.slotPool = null;
        this.slotPoolGateway = null;
        this.testingResourceManagerGateway = null;
    }

    public SlotProvider getSlotProvider() {
        this.checkInitialized();
        return this.slotPool.getSlotProvider();
    }

    public TestingResourceManagerGateway getTestingResourceManagerGateway() {
        this.checkInitialized();
        return this.testingResourceManagerGateway;
    }

    public SlotPoolGateway getSlotPoolGateway() {
        this.checkInitialized();
        return this.slotPoolGateway;
    }

    private void checkInitialized() {
        assert (this.slotPool != null);
    }

    protected void before() throws Throwable {
        if (this.slotPool != null) {
            this.terminateSlotPool();
        }
        this.testingResourceManagerGateway = new TestingResourceManagerGateway();
        this.slotPool = new SlotPool(this.rpcService, new JobID(), this.schedulingStrategy);
        this.slotPool.start(JobMasterId.generate(), "foobar");
        this.slotPoolGateway = (SlotPoolGateway)this.slotPool.getSelfGateway(SlotPoolGateway.class);
        this.slotPool.connectToResourceManager((ResourceManagerGateway)this.testingResourceManagerGateway);
    }

    protected void after() {
        if (this.slotPool != null) {
            this.terminateSlotPool();
            this.slotPool = null;
        }
    }

    private void terminateSlotPool() {
        this.slotPool.shutDown();
        CompletableFuture terminationFuture = this.slotPool.getTerminationFuture();
        terminationFuture.join();
    }
}

