/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.DummySlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotActions;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSharingManager;
import org.apache.flink.runtime.jobmaster.slotpool.TestingAllocatedSlotActions;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SlotSharingManagerTest
extends TestLogger {
    private static final SlotSharingGroupId SLOT_SHARING_GROUP_ID = new SlotSharingGroupId();
    private static final DummySlotOwner SLOT_OWNER = new DummySlotOwner();

    @Test
    public void testRootSlotCreation() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotRequestId slotRequestId = new SlotRequestId();
        SlotRequestId allocatedSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot multiTaskSlot = slotSharingManager.createRootSlot(slotRequestId, new CompletableFuture(), allocatedSlotRequestId);
        Assert.assertEquals((Object)slotRequestId, (Object)multiTaskSlot.getSlotRequestId());
        Assert.assertNotNull((Object)slotSharingManager.getTaskSlot(slotRequestId));
    }

    @Test
    public void testRootSlotRelease() throws ExecutionException, InterruptedException {
        CompletableFuture slotReleasedFuture = new CompletableFuture();
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        allocatedSlotActions.setReleaseSlotConsumer(tuple3 -> slotReleasedFuture.complete(tuple3.f0));
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotRequestId slotRequestId = new SlotRequestId();
        SlotRequestId allocatedSlotRequestId = new SlotRequestId();
        CompletableFuture slotContextFuture = new CompletableFuture();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(slotRequestId, slotContextFuture, allocatedSlotRequestId);
        Assert.assertTrue((boolean)slotSharingManager.contains(slotRequestId));
        rootSlot.release((Throwable)new FlinkException("Test exception"));
        Assert.assertEquals((Object)allocatedSlotRequestId, slotReleasedFuture.get());
        Assert.assertFalse((boolean)slotSharingManager.contains(slotRequestId));
    }

    @Test
    public void testNestedSlotCreation() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), new CompletableFuture(), new SlotRequestId());
        AbstractID singleTaskSlotGroupId = new AbstractID();
        SlotRequestId singleTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(singleTaskSlotRequestId, singleTaskSlotGroupId, Locality.LOCAL);
        AbstractID multiTaskSlotGroupId = new AbstractID();
        SlotRequestId multiTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot multiTaskSlot = rootSlot.allocateMultiTaskSlot(multiTaskSlotRequestId, multiTaskSlotGroupId);
        Assert.assertTrue((boolean)Objects.equals(singleTaskSlotRequestId, singleTaskSlot.getSlotRequestId()));
        Assert.assertTrue((boolean)Objects.equals(multiTaskSlotRequestId, multiTaskSlot.getSlotRequestId()));
        Assert.assertTrue((boolean)rootSlot.contains(singleTaskSlotGroupId));
        Assert.assertTrue((boolean)rootSlot.contains(multiTaskSlotGroupId));
        Assert.assertTrue((boolean)slotSharingManager.contains(singleTaskSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.contains(multiTaskSlotRequestId));
    }

    @Test
    public void testNestedSlotRelease() throws Exception {
        TestingAllocatedSlotActions testingAllocatedSlotActions = new TestingAllocatedSlotActions();
        CompletableFuture releasedSlotFuture = new CompletableFuture();
        testingAllocatedSlotActions.setReleaseSlotConsumer(tuple3 -> releasedSlotFuture.complete(tuple3.f0));
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)testingAllocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotRequestId rootSlotRequestId = new SlotRequestId();
        SlotRequestId allocatedSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(rootSlotRequestId, new CompletableFuture(), allocatedSlotRequestId);
        SlotRequestId singleTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(singleTaskSlotRequestId, new AbstractID(), Locality.LOCAL);
        SlotRequestId multiTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot multiTaskSlot = rootSlot.allocateMultiTaskSlot(multiTaskSlotRequestId, new AbstractID());
        CompletableFuture singleTaskSlotFuture = singleTaskSlot.getLogicalSlotFuture();
        Assert.assertTrue((boolean)slotSharingManager.contains(rootSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.contains(singleTaskSlotRequestId));
        Assert.assertFalse((boolean)singleTaskSlotFuture.isDone());
        FlinkException testException = new FlinkException("Test exception");
        singleTaskSlot.release((Throwable)testException);
        Assert.assertTrue((boolean)singleTaskSlotFuture.isCompletedExceptionally());
        Assert.assertFalse((boolean)slotSharingManager.contains(singleTaskSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.contains(rootSlotRequestId));
        multiTaskSlot.release((Throwable)testException);
        Assert.assertEquals((Object)allocatedSlotRequestId, releasedSlotFuture.get());
        Assert.assertFalse((boolean)slotSharingManager.contains(rootSlotRequestId));
        Assert.assertFalse((boolean)slotSharingManager.contains(multiTaskSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.isEmpty());
    }

    @Test
    public void testInnerSlotRelease() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), new CompletableFuture(), new SlotRequestId());
        SlotSharingManager.MultiTaskSlot multiTaskSlot = rootSlot.allocateMultiTaskSlot(new SlotRequestId(), new AbstractID());
        SlotSharingManager.SingleTaskSlot singleTaskSlot1 = multiTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), new AbstractID(), Locality.LOCAL);
        SlotSharingManager.MultiTaskSlot multiTaskSlot1 = multiTaskSlot.allocateMultiTaskSlot(new SlotRequestId(), new AbstractID());
        Assert.assertTrue((boolean)slotSharingManager.contains(multiTaskSlot1.getSlotRequestId()));
        Assert.assertTrue((boolean)slotSharingManager.contains(singleTaskSlot1.getSlotRequestId()));
        Assert.assertTrue((boolean)slotSharingManager.contains(multiTaskSlot.getSlotRequestId()));
        multiTaskSlot.release((Throwable)new FlinkException("Test exception"));
        Assert.assertFalse((boolean)slotSharingManager.contains(multiTaskSlot1.getSlotRequestId()));
        Assert.assertFalse((boolean)slotSharingManager.contains(singleTaskSlot1.getSlotRequestId()));
        Assert.assertFalse((boolean)slotSharingManager.contains(multiTaskSlot.getSlotRequestId()));
        Assert.assertTrue((boolean)singleTaskSlot1.getLogicalSlotFuture().isCompletedExceptionally());
    }

    @Test
    public void testSlotContextFutureCompletion() throws Exception {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SimpleSlotContext slotContext = new SimpleSlotContext(new AllocationID(), (TaskManagerLocation)new LocalTaskManagerLocation(), 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway());
        CompletableFuture<SimpleSlotContext> slotContextFuture = new CompletableFuture<SimpleSlotContext>();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        Locality locality1 = Locality.LOCAL;
        SlotSharingManager.SingleTaskSlot singleTaskSlot1 = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), new AbstractID(), locality1);
        Locality locality2 = Locality.HOST_LOCAL;
        SlotSharingManager.SingleTaskSlot singleTaskSlot2 = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), new AbstractID(), locality2);
        CompletableFuture logicalSlotFuture1 = singleTaskSlot1.getLogicalSlotFuture();
        CompletableFuture logicalSlotFuture2 = singleTaskSlot2.getLogicalSlotFuture();
        Assert.assertFalse((boolean)logicalSlotFuture1.isDone());
        Assert.assertFalse((boolean)logicalSlotFuture2.isDone());
        slotContextFuture.complete(slotContext);
        Assert.assertTrue((boolean)logicalSlotFuture1.isDone());
        Assert.assertTrue((boolean)logicalSlotFuture2.isDone());
        LogicalSlot logicalSlot1 = (LogicalSlot)logicalSlotFuture1.get();
        LogicalSlot logicalSlot2 = (LogicalSlot)logicalSlotFuture2.get();
        Assert.assertEquals((Object)logicalSlot1.getAllocationId(), (Object)slotContext.getAllocationId());
        Assert.assertEquals((Object)logicalSlot2.getAllocationId(), (Object)slotContext.getAllocationId());
        Assert.assertEquals((Object)locality1, (Object)logicalSlot1.getLocality());
        Assert.assertEquals((Object)locality2, (Object)logicalSlot2.getLocality());
        Locality locality3 = Locality.NON_LOCAL;
        SlotSharingManager.SingleTaskSlot singleTaskSlot3 = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), new AbstractID(), locality3);
        CompletableFuture logicalSlotFuture3 = singleTaskSlot3.getLogicalSlotFuture();
        Assert.assertTrue((boolean)logicalSlotFuture3.isDone());
        LogicalSlot logicalSlot3 = (LogicalSlot)logicalSlotFuture3.get();
        Assert.assertEquals((Object)locality3, (Object)logicalSlot3.getLocality());
        Assert.assertEquals((Object)slotContext.getAllocationId(), (Object)logicalSlot3.getAllocationId());
    }

    @Test
    public void testSlotContextFutureFailure() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        CompletableFuture slotContextFuture = new CompletableFuture();
        Assert.assertTrue((boolean)slotSharingManager.isEmpty());
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), new AbstractID(), Locality.LOCAL);
        slotContextFuture.completeExceptionally((Throwable)new FlinkException("Test exception"));
        Assert.assertTrue((boolean)singleTaskSlot.getLogicalSlotFuture().isCompletedExceptionally());
        Assert.assertTrue((boolean)slotSharingManager.isEmpty());
        Assert.assertTrue((boolean)slotSharingManager.getResolvedRootSlots().isEmpty());
        Assert.assertTrue((boolean)slotSharingManager.getUnresolvedRootSlots().isEmpty());
    }

    @Test
    public void testRootSlotTransition() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        CompletableFuture<SimpleSlotContext> slotContextFuture = new CompletableFuture<SimpleSlotContext>();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        Assert.assertTrue((boolean)slotSharingManager.getUnresolvedRootSlots().contains(rootSlot));
        Assert.assertFalse((boolean)slotSharingManager.getResolvedRootSlots().contains(rootSlot));
        slotContextFuture.complete(new SimpleSlotContext(new AllocationID(), (TaskManagerLocation)new LocalTaskManagerLocation(), 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway()));
        Assert.assertFalse((boolean)slotSharingManager.getUnresolvedRootSlots().contains(rootSlot));
        Assert.assertTrue((boolean)slotSharingManager.getResolvedRootSlots().contains(rootSlot));
    }

    @Test
    public void testGetResolvedSlot() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), CompletableFuture.completedFuture(new SimpleSlotContext(new AllocationID(), (TaskManagerLocation)new LocalTaskManagerLocation(), 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway())), new SlotRequestId());
        AbstractID groupId = new AbstractID();
        SlotSharingManager.MultiTaskSlotLocality resolvedRootSlotLocality = slotSharingManager.getResolvedRootSlot(groupId, (SchedulingStrategy)LocationPreferenceSchedulingStrategy.getInstance(), SlotProfile.noRequirements());
        Assert.assertNotNull((Object)resolvedRootSlotLocality);
        Assert.assertEquals((Object)Locality.UNCONSTRAINED, (Object)resolvedRootSlotLocality.getLocality());
        Assert.assertEquals((Object)rootSlot.getSlotRequestId(), (Object)resolvedRootSlotLocality.getMultiTaskSlot().getSlotRequestId());
        SlotSharingManager.MultiTaskSlot resolvedRootSlot = resolvedRootSlotLocality.getMultiTaskSlot();
        resolvedRootSlot.allocateSingleTaskSlot(new SlotRequestId(), groupId, resolvedRootSlotLocality.getLocality());
        SlotSharingManager.MultiTaskSlotLocality resolvedRootSlot1 = slotSharingManager.getResolvedRootSlot(groupId, (SchedulingStrategy)LocationPreferenceSchedulingStrategy.getInstance(), SlotProfile.noRequirements());
        Assert.assertNull((Object)resolvedRootSlot1);
    }

    @Test
    public void testGetResolvedSlotWithLocationPreferences() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotSharingManager.MultiTaskSlot rootSlot1 = slotSharingManager.createRootSlot(new SlotRequestId(), CompletableFuture.completedFuture(new SimpleSlotContext(new AllocationID(), (TaskManagerLocation)new LocalTaskManagerLocation(), 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway())), new SlotRequestId());
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        SlotSharingManager.MultiTaskSlot rootSlot2 = slotSharingManager.createRootSlot(new SlotRequestId(), CompletableFuture.completedFuture(new SimpleSlotContext(new AllocationID(), (TaskManagerLocation)taskManagerLocation, 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway())), new SlotRequestId());
        AbstractID groupId = new AbstractID();
        SlotProfile slotProfile = SlotProfile.preferredLocality((ResourceProfile)ResourceProfile.UNKNOWN, Collections.singleton(taskManagerLocation));
        SlotSharingManager.MultiTaskSlotLocality resolvedRootSlot1 = slotSharingManager.getResolvedRootSlot(groupId, (SchedulingStrategy)LocationPreferenceSchedulingStrategy.getInstance(), slotProfile);
        Assert.assertNotNull((Object)resolvedRootSlot1);
        Assert.assertEquals((Object)Locality.LOCAL, (Object)resolvedRootSlot1.getLocality());
        Assert.assertEquals((Object)rootSlot2.getSlotRequestId(), (Object)resolvedRootSlot1.getMultiTaskSlot().getSlotRequestId());
        resolvedRootSlot1.getMultiTaskSlot().allocateSingleTaskSlot(new SlotRequestId(), groupId, resolvedRootSlot1.getLocality());
        SlotSharingManager.MultiTaskSlotLocality resolvedRootSlot2 = slotSharingManager.getResolvedRootSlot(groupId, (SchedulingStrategy)LocationPreferenceSchedulingStrategy.getInstance(), slotProfile);
        Assert.assertNotNull((Object)resolvedRootSlot2);
        Assert.assertNotSame((Object)Locality.LOCAL, (Object)resolvedRootSlot2.getLocality());
        Assert.assertEquals((Object)rootSlot1.getSlotRequestId(), (Object)resolvedRootSlot2.getMultiTaskSlot().getSlotRequestId());
    }

    @Test
    public void testGetUnresolvedSlot() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotSharingManager.MultiTaskSlot rootSlot1 = slotSharingManager.createRootSlot(new SlotRequestId(), new CompletableFuture(), new SlotRequestId());
        AbstractID groupId = new AbstractID();
        SlotSharingManager.MultiTaskSlot unresolvedRootSlot = slotSharingManager.getUnresolvedRootSlot(groupId);
        Assert.assertNotNull((Object)unresolvedRootSlot);
        Assert.assertEquals((Object)rootSlot1.getSlotRequestId(), (Object)unresolvedRootSlot.getSlotRequestId());
        unresolvedRootSlot.allocateSingleTaskSlot(new SlotRequestId(), groupId, Locality.UNKNOWN);
        SlotSharingManager.MultiTaskSlot unresolvedRootSlot1 = slotSharingManager.getUnresolvedRootSlot(groupId);
        Assert.assertNull((Object)unresolvedRootSlot1);
    }
}

