/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;

public class TestingLeaderElectionService
implements LeaderElectionService {
    private LeaderContender contender;
    private boolean hasLeadership = false;
    private CompletableFuture<UUID> confirmationFuture = null;
    private UUID issuedLeaderSessionId = null;

    public synchronized CompletableFuture<UUID> getConfirmationFuture() {
        return this.confirmationFuture;
    }

    public synchronized void start(LeaderContender contender) throws Exception {
        this.contender = contender;
    }

    public synchronized void stop() throws Exception {
    }

    public synchronized void confirmLeaderSessionID(UUID leaderSessionID) {
        if (this.confirmationFuture != null) {
            this.confirmationFuture.complete(leaderSessionID);
        }
    }

    public synchronized boolean hasLeadership(@Nonnull UUID leaderSessionId) {
        return this.hasLeadership && leaderSessionId.equals(this.issuedLeaderSessionId);
    }

    public synchronized CompletableFuture<UUID> isLeader(UUID leaderSessionID) {
        if (this.confirmationFuture != null) {
            this.confirmationFuture.cancel(false);
        }
        this.confirmationFuture = new CompletableFuture();
        this.hasLeadership = true;
        this.issuedLeaderSessionId = leaderSessionID;
        this.contender.grantLeadership(leaderSessionID);
        return this.confirmationFuture;
    }

    public synchronized void notLeader() {
        this.hasLeadership = false;
        this.contender.revokeLeadership();
    }

    public synchronized void reset() {
        this.contender = null;
        this.hasLeadership = false;
    }

    public synchronized String getAddress() {
        return this.contender.getAddress();
    }

    public synchronized boolean isStarted() {
        return this.contender != null;
    }
}

