/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.InMemorySorterFactory;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.sort.UnilateralSortMerger;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.runtime.util.EmptyMutableObjectIterator;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class UnilateralSortMergerTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInMemorySorterDisposal() throws Exception {
        TestingInMemorySorterFactory inMemorySorterFactory = new TestingInMemorySorterFactory();
        int numPages = 32;
        MemoryManager memoryManager = new MemoryManager(0x100000L, 1);
        IOManagerAsync ioManager = new IOManagerAsync();
        DummyInvokable parentTask = new DummyInvokable();
        try {
            List memory = memoryManager.allocatePages((Object)parentTask, 32);
            UnilateralSortMerger unilateralSortMerger = new UnilateralSortMerger(memoryManager, memory, (IOManager)ioManager, EmptyMutableObjectIterator.get(), (AbstractInvokable)parentTask, TestData.getIntIntTupleSerializerFactory(), TestData.getIntIntTupleComparator(), 10, 2, 1.0f, true, false, false, inMemorySorterFactory);
            Collection<TestingInMemorySorter<?>> inMemorySorters = inMemorySorterFactory.getInMemorySorters();
            Assert.assertThat(inMemorySorters, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
            unilateralSortMerger.close();
            Assert.assertThat((Object)unilateralSortMerger.closed, (Matcher)Matchers.is((Object)true));
            for (TestingInMemorySorter<?> inMemorySorter : inMemorySorters) {
                Assert.assertThat((Object)inMemorySorter.isDisposed(), (Matcher)Matchers.is((Object)true));
            }
        }
        finally {
            ioManager.shutdown();
            memoryManager.shutdown();
        }
    }

    private static final class TestingInMemorySorter<T>
    implements InMemorySorter<T> {
        private volatile boolean isDisposed;

        private TestingInMemorySorter() {
        }

        public boolean isDisposed() {
            return this.isDisposed;
        }

        public void reset() {
        }

        public boolean isEmpty() {
            return true;
        }

        public void dispose() {
            this.isDisposed = true;
        }

        public long getCapacity() {
            return 0L;
        }

        public long getOccupancy() {
            return 0L;
        }

        public T getRecord(int logicalPosition) throws IOException {
            return null;
        }

        public T getRecord(T reuse, int logicalPosition) throws IOException {
            return null;
        }

        public boolean write(T record) throws IOException {
            return false;
        }

        public MutableObjectIterator<T> getIterator() {
            return null;
        }

        public void writeToOutput(ChannelWriterOutputView output) throws IOException {
        }

        public void writeToOutput(ChannelWriterOutputView output, LargeRecordHandler<T> largeRecordsOutput) throws IOException {
        }

        public void writeToOutput(ChannelWriterOutputView output, int start, int num) throws IOException {
        }

        public int compare(int i, int j) {
            return 0;
        }

        public int compare(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
            return 0;
        }

        public void swap(int i, int j) {
        }

        public void swap(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        }

        public int size() {
            return 0;
        }

        public int recordSize() {
            return 0;
        }

        public int recordsPerSegment() {
            return 0;
        }
    }

    private static final class TestingInMemorySorterFactory<T>
    implements InMemorySorterFactory<T> {
        private final Collection<TestingInMemorySorter<?>> inMemorySorters = new ArrayList(10);

        private TestingInMemorySorterFactory() {
        }

        Collection<TestingInMemorySorter<?>> getInMemorySorters() {
            return this.inMemorySorters;
        }

        public InMemorySorter<T> create(List<MemorySegment> sortSegments) {
            TestingInMemorySorter testingInMemorySorter = new TestingInMemorySorter();
            this.inMemorySorters.add(testingInMemorySorter);
            return testingInMemorySorter;
        }
    }
}

