/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.TestingResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceManagerTest
extends TestLogger {
    private TestingRpcService rpcService;

    @Before
    public void setUp() {
        this.rpcService = new TestingRpcService();
    }

    @After
    public void tearDown() throws ExecutionException, InterruptedException {
        if (this.rpcService != null) {
            this.rpcService.stopService().get();
            this.rpcService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestTaskManagerInfo() throws Exception {
        TestingHighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        SlotManager slotManager = new SlotManager(this.rpcService.getScheduledExecutor(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService((HighAvailabilityServices)highAvailabilityServices, this.rpcService.getScheduledExecutor(), TestingUtils.infiniteTime());
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        highAvailabilityServices.setResourceManagerLeaderElectionService(resourceManagerLeaderElectionService);
        TestingResourceManager resourceManager = new TestingResourceManager((RpcService)this.rpcService, "resourcemanager", ResourceID.generate(), highAvailabilityServices, new HeartbeatServices(1000L, 10000L), slotManager, NoOpMetricRegistry.INSTANCE, jobLeaderIdService, testingFatalErrorHandler, UnregisteredMetricGroups.createUnregisteredJobManagerMetricGroup());
        resourceManager.start();
        try {
            ResourceID taskManagerId = ResourceID.generate();
            ResourceManagerGateway resourceManagerGateway = (ResourceManagerGateway)resourceManager.getSelfGateway(ResourceManagerGateway.class);
            TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
            resourceManagerLeaderElectionService.isLeader(UUID.randomUUID()).get();
            this.rpcService.registerGateway(taskExecutorGateway.getAddress(), (RpcGateway)taskExecutorGateway);
            HardwareDescription hardwareDescription = new HardwareDescription(42, 1337L, 1337L, 0L);
            int dataPort = 1234;
            CompletableFuture registrationResponseFuture = resourceManagerGateway.registerTaskExecutor(taskExecutorGateway.getAddress(), taskManagerId, 1234, hardwareDescription, TestingUtils.TIMEOUT());
            Assert.assertTrue((boolean)(registrationResponseFuture.get() instanceof RegistrationResponse.Success));
            CompletableFuture taskManagerInfoFuture = resourceManagerGateway.requestTaskManagerInfo(taskManagerId, TestingUtils.TIMEOUT());
            TaskManagerInfo taskManagerInfo = (TaskManagerInfo)taskManagerInfoFuture.get();
            Assert.assertEquals((Object)taskManagerId, (Object)taskManagerInfo.getResourceId());
            Assert.assertEquals((Object)hardwareDescription, (Object)taskManagerInfo.getHardwareDescription());
            Assert.assertEquals((Object)taskExecutorGateway.getAddress(), (Object)taskManagerInfo.getAddress());
            Assert.assertEquals((long)1234L, (long)taskManagerInfo.getDataPort());
            Assert.assertEquals((long)0L, (long)taskManagerInfo.getNumberSlots());
            Assert.assertEquals((long)0L, (long)taskManagerInfo.getNumberAvailableSlots());
            testingFatalErrorHandler.rethrowError();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)resourceManager, (Time)TestingUtils.TIMEOUT());
            highAvailabilityServices.close();
        }
    }
}

