/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActionsBuilder;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class SlotProtocolTest
extends TestLogger {
    private static final long timeout = 10000L;
    private static final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
    private static final ScheduledExecutor scheduledExecutor = new ScheduledExecutorServiceAdapter(scheduledExecutorService);

    @AfterClass
    public static void afterClass() {
        ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{scheduledExecutorService});
    }

    @Test
    public void testSlotsUnavailableRequest() throws Exception {
        JobID jobID = new JobID();
        ResourceManagerId rmLeaderID = ResourceManagerId.generate();
        try (SlotManager slotManager = new SlotManager(scheduledExecutor, TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());){
            CompletableFuture resourceProfileFuture = new CompletableFuture();
            TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceConsumer(resourceProfileFuture::complete).build();
            slotManager.start(rmLeaderID, Executors.directExecutor(), (ResourceActions)resourceManagerActions);
            AllocationID allocationID = new AllocationID();
            ResourceProfile resourceProfile = new ResourceProfile(1.0, 100);
            String targetAddress = "foobar";
            SlotRequest slotRequest = new SlotRequest(jobID, allocationID, resourceProfile, "foobar");
            slotManager.registerSlotRequest(slotRequest);
            Assert.assertThat(resourceProfileFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)slotRequest.getResourceProfile())));
            CompletableFuture requestFuture = new CompletableFuture();
            TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple5 -> {
                requestFuture.complete(Tuple3.of((Object)tuple5.f0, (Object)tuple5.f1, (Object)tuple5.f2));
                return new CompletableFuture();
            }).createTestingTaskExecutorGateway();
            ResourceID resourceID = ResourceID.generate();
            SlotID slotID = new SlotID(resourceID, 0);
            SlotStatus slotStatus = new SlotStatus(slotID, resourceProfile);
            SlotReport slotReport = new SlotReport(Collections.singletonList(slotStatus));
            slotManager.registerTaskManager(new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway), slotReport);
            Assert.assertThat(requestFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Tuple3.of((Object)slotID, (Object)jobID, (Object)allocationID))));
        }
    }

    @Test
    public void testSlotAvailableRequest() throws Exception {
        JobID jobID = new JobID();
        ResourceManagerId rmLeaderID = ResourceManagerId.generate();
        CompletableFuture requestFuture = new CompletableFuture();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple5 -> {
            requestFuture.complete(Tuple3.of((Object)tuple5.f0, (Object)tuple5.f1, (Object)tuple5.f2));
            return new CompletableFuture();
        }).createTestingTaskExecutorGateway();
        try (SlotManager slotManager = new SlotManager(scheduledExecutor, TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());){
            TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
            slotManager.start(rmLeaderID, Executors.directExecutor(), (ResourceActions)resourceManagerActions);
            ResourceID resourceID = ResourceID.generate();
            AllocationID allocationID = new AllocationID();
            ResourceProfile resourceProfile = new ResourceProfile(1.0, 100);
            SlotID slotID = new SlotID(resourceID, 0);
            SlotStatus slotStatus = new SlotStatus(slotID, resourceProfile);
            SlotReport slotReport = new SlotReport(Collections.singletonList(slotStatus));
            slotManager.registerTaskManager(new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway), slotReport);
            String targetAddress = "foobar";
            SlotRequest slotRequest = new SlotRequest(jobID, allocationID, resourceProfile, "foobar");
            slotManager.registerSlotRequest(slotRequest);
            Assert.assertThat(requestFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Tuple3.of((Object)slotID, (Object)jobID, (Object)allocationID))));
        }
    }
}

