/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.util.function.FunctionWithException;

public class TestingResourceActions
implements ResourceActions {
    @Nonnull
    private final BiConsumer<InstanceID, Exception> releaseResourceConsumer;
    @Nonnull
    private final FunctionWithException<ResourceProfile, Collection<ResourceProfile>, ResourceManagerException> allocateResourceFunction;
    @Nonnull
    private final Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer;

    public TestingResourceActions(@Nonnull BiConsumer<InstanceID, Exception> releaseResourceConsumer, @Nonnull FunctionWithException<ResourceProfile, Collection<ResourceProfile>, ResourceManagerException> allocateResourceFunction, @Nonnull Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer) {
        this.releaseResourceConsumer = releaseResourceConsumer;
        this.allocateResourceFunction = allocateResourceFunction;
        this.notifyAllocationFailureConsumer = notifyAllocationFailureConsumer;
    }

    public void releaseResource(InstanceID instanceId, Exception cause) {
        this.releaseResourceConsumer.accept(instanceId, cause);
    }

    public Collection<ResourceProfile> allocateResource(ResourceProfile resourceProfile) throws ResourceManagerException {
        return (Collection)this.allocateResourceFunction.apply((Object)resourceProfile);
    }

    public void notifyAllocationFailure(JobID jobId, AllocationID allocationId, Exception cause) {
        this.notifyAllocationFailureConsumer.accept((Tuple3<JobID, AllocationID, Exception>)Tuple3.of((Object)jobId, (Object)allocationId, (Object)cause));
    }
}

