/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.flink.runtime.io.network.netty.NettyLeakDetectionResource;
import org.apache.flink.runtime.rest.MultipartUploadResource;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class FileUploadHandlerTest
extends TestLogger {
    @ClassRule
    public static final MultipartUploadResource MULTIPART_UPLOAD_RESOURCE = new MultipartUploadResource();
    private static final ObjectMapper OBJECT_MAPPER = RestMapperUtils.getStrictObjectMapper();
    @ClassRule
    public static final NettyLeakDetectionResource LEAK_DETECTION = new NettyLeakDetectionResource();

    @After
    public void reset() {
        MULTIPART_UPLOAD_RESOURCE.resetState();
    }

    private static Request buildMalformedRequest(String headerUrl) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addFilePart(builder);
        builder = builder.addPart(RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)"crash"));
        return FileUploadHandlerTest.finalizeRequest(builder, headerUrl);
    }

    private static Request buildMixedRequestWithUnknownAttribute(String headerUrl) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addJsonPart(builder, new MultipartUploadResource.TestRequestBody(), "hello");
        builder = FileUploadHandlerTest.addFilePart(builder);
        return FileUploadHandlerTest.finalizeRequest(builder, headerUrl);
    }

    private static Request buildFileRequest(String headerUrl) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addFilePart(builder);
        return FileUploadHandlerTest.finalizeRequest(builder, headerUrl);
    }

    private static Request buildJsonRequest(String headerUrl, MultipartUploadResource.TestRequestBody json) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addJsonPart(builder, json, "request");
        return FileUploadHandlerTest.finalizeRequest(builder, headerUrl);
    }

    private static Request buildMixedRequest(String headerUrl, MultipartUploadResource.TestRequestBody json) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addJsonPart(builder, json, "request");
        builder = FileUploadHandlerTest.addFilePart(builder);
        return FileUploadHandlerTest.finalizeRequest(builder, headerUrl);
    }

    private static Request finalizeRequest(MultipartBody.Builder builder, String headerUrl) {
        MultipartBody multipartBody = builder.setType(MultipartBody.FORM).build();
        return new Request.Builder().url(FileUploadHandlerTest.MULTIPART_UPLOAD_RESOURCE.serverAddress + headerUrl).post((RequestBody)multipartBody).build();
    }

    private static MultipartBody.Builder addFilePart(MultipartBody.Builder builder) {
        for (File file : MULTIPART_UPLOAD_RESOURCE.getFilesToUpload()) {
            RequestBody filePayload = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
            builder = builder.addFormDataPart(file.getName(), file.getName(), filePayload);
        }
        return builder;
    }

    private static MultipartBody.Builder addJsonPart(MultipartBody.Builder builder, MultipartUploadResource.TestRequestBody jsonRequestBody, String attribute) throws IOException {
        StringWriter sw = new StringWriter();
        OBJECT_MAPPER.writeValue((Writer)sw, (Object)jsonRequestBody);
        String jsonPayload = sw.toString();
        return builder.addFormDataPart(attribute, jsonPayload);
    }

    @Test
    public void testMixedMultipart() throws Exception {
        OkHttpClient client = new OkHttpClient();
        MultipartUploadResource.MultipartMixedHandler mixedHandler = MULTIPART_UPLOAD_RESOURCE.getMixedHandler();
        Request jsonRequest = FileUploadHandlerTest.buildJsonRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(jsonRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), (long)response.code());
        }
        Request fileRequest = FileUploadHandlerTest.buildFileRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        MultipartUploadResource.TestRequestBody json = new MultipartUploadResource.TestRequestBody();
        Request mixedRequest = FileUploadHandlerTest.buildMixedRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL(), json);
        try (Response response = client.newCall(mixedRequest).execute();){
            Assert.assertEquals((long)mixedHandler.getMessageHeaders().getResponseStatusCode().code(), (long)response.code());
            Assert.assertEquals((Object)json, (Object)mixedHandler.lastReceivedRequest);
        }
    }

    @Test
    public void testJsonMultipart() throws Exception {
        OkHttpClient client = new OkHttpClient();
        MultipartUploadResource.MultipartJsonHandler jsonHandler = MULTIPART_UPLOAD_RESOURCE.getJsonHandler();
        MultipartUploadResource.TestRequestBody json = new MultipartUploadResource.TestRequestBody();
        Request jsonRequest = FileUploadHandlerTest.buildJsonRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL(), json);
        try (Response response = client.newCall(jsonRequest).execute();){
            Assert.assertEquals((long)jsonHandler.getMessageHeaders().getResponseStatusCode().code(), (long)response.code());
            Assert.assertEquals((Object)json, (Object)jsonHandler.lastReceivedRequest);
        }
        Request fileRequest = FileUploadHandlerTest.buildFileRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        Request mixedRequest = FileUploadHandlerTest.buildMixedRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(mixedRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
    }

    @Test
    public void testFileMultipart() throws Exception {
        OkHttpClient client = new OkHttpClient();
        MultipartUploadResource.MultipartFileHandler fileHandler = MULTIPART_UPLOAD_RESOURCE.getFileHandler();
        Request jsonRequest = FileUploadHandlerTest.buildJsonRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(jsonRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        Request fileRequest = FileUploadHandlerTest.buildFileRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assert.assertEquals((long)fileHandler.getMessageHeaders().getResponseStatusCode().code(), (long)response.code());
        }
        Request mixedRequest = FileUploadHandlerTest.buildMixedRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(mixedRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
    }

    @Test
    public void testUploadCleanupOnUnknownAttribute() throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = FileUploadHandlerTest.buildMixedRequestWithUnknownAttribute(MULTIPART_UPLOAD_RESOURCE.getMixedHandler().getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        MULTIPART_UPLOAD_RESOURCE.assertUploadDirectoryIsEmpty();
    }

    @Test
    public void testUploadCleanupOnFailure() throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = FileUploadHandlerTest.buildMalformedRequest(MULTIPART_UPLOAD_RESOURCE.getMixedHandler().getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((long)HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), (long)response.code());
        }
        MULTIPART_UPLOAD_RESOURCE.assertUploadDirectoryIsEmpty();
    }
}

