/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RestServerEndpointConfigurationTest
extends TestLogger {
    private static final String ADDRESS = "123.123.123.123";
    private static final String BIND_ADDRESS = "023.023.023.023";
    private static final int PORT = 7282;
    private static final int CONTENT_LENGTH = 1234;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testBasicMapping() throws ConfigurationException {
        Configuration originalConfig = new Configuration();
        originalConfig.setString(RestOptions.ADDRESS, ADDRESS);
        originalConfig.setString(RestOptions.BIND_ADDRESS, BIND_ADDRESS);
        originalConfig.setInteger(RestOptions.PORT, 7282);
        originalConfig.setInteger(RestOptions.SERVER_MAX_CONTENT_LENGTH, 1234);
        originalConfig.setString(WebOptions.TMP_DIR, this.temporaryFolder.getRoot().getAbsolutePath());
        RestServerEndpointConfiguration result = RestServerEndpointConfiguration.fromConfiguration((Configuration)originalConfig);
        Assert.assertEquals((Object)ADDRESS, (Object)result.getRestAddress());
        Assert.assertEquals((Object)BIND_ADDRESS, (Object)result.getRestBindAddress());
        Assert.assertEquals((long)7282L, (long)result.getRestBindPort());
        Assert.assertEquals((long)1234L, (long)result.getMaxContentLength());
        Assert.assertThat((Object)result.getUploadDir().toAbsolutePath().toString(), (Matcher)CoreMatchers.containsString((String)this.temporaryFolder.getRoot().getAbsolutePath()));
    }
}

