/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class RestServerEndpointTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testRestHandlerUrlSorting() {
        int numberHandlers = 5;
        ArrayList<String> handlerUrls = new ArrayList<String>(5);
        handlerUrls.add("/jobs/overview");
        handlerUrls.add("/jobs/:jobid");
        handlerUrls.add("/jobs");
        handlerUrls.add("/:*");
        handlerUrls.add("/jobs/:jobid/config");
        ArrayList<String> expected = new ArrayList<String>(5);
        expected.add("/jobs");
        expected.add("/jobs/overview");
        expected.add("/jobs/:jobid");
        expected.add("/jobs/:jobid/config");
        expected.add("/:*");
        Collections.sort(handlerUrls, new RestServerEndpoint.RestHandlerUrlComparator.CaseInsensitiveOrderComparator());
        Assert.assertEquals(expected, handlerUrls);
    }

    @Test
    public void testCreateUploadDir() throws Exception {
        File file = this.temporaryFolder.newFolder();
        Path testUploadDir = file.toPath().resolve("testUploadDir");
        Assert.assertFalse((boolean)Files.exists(testUploadDir, new LinkOption[0]));
        RestServerEndpoint.createUploadDir((Path)testUploadDir, (Logger)NOPLogger.NOP_LOGGER);
        Assert.assertTrue((boolean)Files.exists(testUploadDir, new LinkOption[0]));
    }

    @Test
    public void testCreateUploadDirFails() throws Exception {
        File file = this.temporaryFolder.newFolder();
        Assume.assumeTrue((boolean)file.setWritable(false));
        Path testUploadDir = file.toPath().resolve("testUploadDir");
        Assert.assertFalse((boolean)Files.exists(testUploadDir, new LinkOption[0]));
        try {
            RestServerEndpoint.createUploadDir((Path)testUploadDir, (Logger)NOPLogger.NOP_LOGGER);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

