/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.rest.RestClientConfiguration;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.RestServerEndpointITCase;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class RestServerSSLAuthITCase
extends TestLogger {
    private static final String KEY_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/local127.keystore").getFile();
    private static final String TRUST_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/local127.truststore").getFile();
    private static final String UNTRUSTED_KEY_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/untrusted.keystore").getFile();
    private static final Time timeout = Time.seconds((long)10L);
    private RestfulGateway restfulGateway;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectFailure() throws Exception {
        RestServerEndpointITCase.TestRestClient restClient = null;
        RestServerEndpointITCase.TestRestServerEndpoint serverEndpoint = null;
        try {
            Configuration baseConfig = new Configuration();
            baseConfig.setInteger(RestOptions.PORT, 0);
            baseConfig.setString(RestOptions.ADDRESS, "localhost");
            baseConfig.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
            baseConfig.setBoolean(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, true);
            baseConfig.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_RSA_WITH_AES_128_CBC_SHA");
            Configuration serverConfig = new Configuration(baseConfig);
            serverConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_FILE);
            serverConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "password");
            serverConfig.setString(SecurityOptions.SSL_REST_KEYSTORE, KEY_STORE_FILE);
            serverConfig.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "password");
            serverConfig.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "password");
            Configuration clientConfig = new Configuration(baseConfig);
            clientConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE, UNTRUSTED_KEY_STORE_FILE);
            clientConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "password");
            clientConfig.setString(SecurityOptions.SSL_REST_KEYSTORE, KEY_STORE_FILE);
            clientConfig.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "password");
            clientConfig.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "password");
            RestServerEndpointConfiguration restServerConfig = RestServerEndpointConfiguration.fromConfiguration((Configuration)serverConfig);
            RestClientConfiguration restClientConfig = RestClientConfiguration.fromConfiguration((Configuration)clientConfig);
            TestingRestfulGateway restfulGateway = TestingRestfulGateway.newBuilder().build();
            RestServerEndpointITCase.TestVersionHandler testVersionHandler = new RestServerEndpointITCase.TestVersionHandler(CompletableFuture.completedFuture("http://localhost:1234"), (GatewayRetriever<? extends RestfulGateway>)((GatewayRetriever)() -> CompletableFuture.completedFuture(restfulGateway)), RpcUtils.INF_TIMEOUT);
            serverEndpoint = new RestServerEndpointITCase.TestRestServerEndpoint(restServerConfig, Arrays.asList(Tuple2.of((Object)testVersionHandler.getMessageHeaders(), (Object)((Object)testVersionHandler))));
            restClient = new RestServerEndpointITCase.TestRestClient(restClientConfig);
            serverEndpoint.start();
            CompletableFuture response = restClient.sendRequest(serverEndpoint.getServerAddress().getHostName(), serverEndpoint.getServerAddress().getPort(), RestServerEndpointITCase.TestVersionHeaders.INSTANCE, (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance(), Collections.emptyList());
            response.get(60L, TimeUnit.SECONDS);
            Assert.fail((String)"should never complete normally");
        }
        catch (ExecutionException exception) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)exception, SSLHandshakeException.class).isPresent());
        }
        finally {
            if (restClient != null) {
                restClient.shutdown(timeout);
            }
            if (serverEndpoint != null) {
                serverEndpoint.close();
            }
        }
    }
}

