/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingMetricsHandlerTestBase;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingSubtasksMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedSubtaskMetricsParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class AggregatingSubtasksMetricsHandlerTest
extends AggregatingMetricsHandlerTestBase<AggregatingSubtasksMetricsHandler, AggregatedSubtaskMetricsParameters> {
    private static final JobID JOB_ID = JobID.generate();
    private static final JobVertexID TASK_ID = new JobVertexID();

    @Override
    protected Tuple2<String, List<String>> getFilter() {
        return Tuple2.of((Object)"subtasks", Arrays.asList("1", "3"));
    }

    @Override
    protected Map<String, String> getPathParameters() {
        HashMap<String, String> pathParameters = new HashMap<String, String>(4);
        pathParameters.put("jobid", JOB_ID.toString());
        pathParameters.put("vertexid", TASK_ID.toString());
        return pathParameters;
    }

    @Override
    protected Collection<MetricDump> getMetricDumps() {
        ArrayList<MetricDump> dumps = new ArrayList<MetricDump>(3);
        QueryScopeInfo.TaskQueryScopeInfo task1 = new QueryScopeInfo.TaskQueryScopeInfo(JOB_ID.toString(), TASK_ID.toString(), 1, "abc");
        MetricDump.CounterDump cd1 = new MetricDump.CounterDump((QueryScopeInfo)task1, "metric1", 1L);
        dumps.add((MetricDump)cd1);
        QueryScopeInfo.TaskQueryScopeInfo task2 = new QueryScopeInfo.TaskQueryScopeInfo(JOB_ID.toString(), TASK_ID.toString(), 2, "abc");
        MetricDump.CounterDump cd2 = new MetricDump.CounterDump((QueryScopeInfo)task2, "metric1", 3L);
        dumps.add((MetricDump)cd2);
        QueryScopeInfo.TaskQueryScopeInfo task3 = new QueryScopeInfo.TaskQueryScopeInfo(JOB_ID.toString(), TASK_ID.toString(), 3, "abc");
        MetricDump.CounterDump cd3 = new MetricDump.CounterDump((QueryScopeInfo)task3, "metric2", 5L);
        dumps.add((MetricDump)cd3);
        return dumps;
    }

    @Override
    protected AggregatingSubtasksMetricsHandler getHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, Executor executor, MetricFetcher<?> fetcher) {
        return new AggregatingSubtasksMetricsHandler(localRestAddress, leaderRetriever, timeout, responseHeaders, executor, fetcher);
    }
}

