/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.Keyed;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.shaded.guava18.com.google.common.primitives.UnsignedBytes;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class InternalPriorityQueueTestBase
extends TestLogger {
    protected static final KeyGroupRange KEY_GROUP_RANGE = new KeyGroupRange(0, 2);
    protected static final KeyExtractorFunction<TestElement> KEY_EXTRACTOR_FUNCTION = TestElement::getKey;
    protected static final PriorityComparator<TestElement> TEST_ELEMENT_PRIORITY_COMPARATOR = (left, right) -> Long.compare(left.getPriority(), right.getPriority());
    protected static final Comparator<TestElement> TEST_ELEMENT_COMPARATOR = new TestElementComparator();

    protected Comparator<Long> getTestElementPriorityComparator() {
        return Long::compareTo;
    }

    private long getHighestPriorityValueForComparator() {
        return this.getTestElementPriorityComparator().compare(-1L, 1L) > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    protected static void insertRandomElements(@Nonnull InternalPriorityQueue<TestElement> priorityQueue, @Nonnull Set<TestElement> checkSet, int count) {
        ThreadLocalRandom localRandom = ThreadLocalRandom.current();
        int numUniqueKeys = Math.max(count / 4, 64);
        long duplicatePriority = Long.MIN_VALUE;
        boolean checkEndSizes = priorityQueue.isEmpty();
        for (int i = 0; i < count; ++i) {
            long elementPriority;
            TestElement element;
            do {
                if (duplicatePriority == Long.MIN_VALUE) {
                    elementPriority = localRandom.nextLong();
                    continue;
                }
                elementPriority = duplicatePriority;
                duplicatePriority = Long.MIN_VALUE;
            } while (!checkSet.add(element = new TestElement(localRandom.nextInt(numUniqueKeys), elementPriority)));
            if (localRandom.nextInt(10) == 0) {
                duplicatePriority = element.getPriority();
            }
            boolean headChangedIndicated = priorityQueue.add((Object)element);
            if (!element.equals(priorityQueue.peek())) continue;
            Assert.assertTrue((boolean)headChangedIndicated);
        }
        if (checkEndSizes) {
            Assert.assertEquals((long)count, (long)priorityQueue.size());
        }
    }

    @Test
    public void testPeekPollOrder() {
        TestElement testElement;
        int initialCapacity = 4;
        int testSize = 1000;
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(4);
        HashSet<TestElement> checkSet = new HashSet<TestElement>(1000);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 1000);
        long lastPriorityValue = this.getHighestPriorityValueForComparator();
        int lastSize = priorityQueue.size();
        Assert.assertEquals((long)1000L, (long)lastSize);
        while ((testElement = (TestElement)priorityQueue.peek()) != null) {
            Assert.assertFalse((boolean)priorityQueue.isEmpty());
            Assert.assertEquals((long)lastSize, (long)priorityQueue.size());
            Assert.assertEquals((Object)testElement, (Object)priorityQueue.poll());
            Assert.assertTrue((boolean)checkSet.remove(testElement));
            Assert.assertTrue((comparator.compare(testElement.getPriority(), lastPriorityValue) >= 0 ? 1 : 0) != 0);
            lastPriorityValue = testElement.getPriority();
            --lastSize;
        }
        Assert.assertTrue((boolean)priorityQueue.isEmpty());
        Assert.assertEquals((long)0L, (long)priorityQueue.size());
        Assert.assertEquals((long)0L, (long)checkSet.size());
    }

    @Test
    public void testRemoveInsertMixKeepsOrder() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(3);
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int testSize = 300;
        int addCounterMax = 75;
        int iterationsTillNextAdds = random.nextInt(75);
        HashSet<TestElement> checkSet = new HashSet<TestElement>(300);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 300);
        while (!checkSet.isEmpty()) {
            long highestPrioValue = this.getHighestPriorityValueForComparator();
            Iterator<TestElement> iterator = checkSet.iterator();
            TestElement element = iterator.next();
            iterator.remove();
            boolean removesHead = element.equals(priorityQueue.peek());
            if (removesHead) {
                Assert.assertTrue((boolean)priorityQueue.remove((Object)element));
            } else {
                priorityQueue.remove((Object)element);
            }
            long currentPriorityWatermark = removesHead ? element.getPriority() : highestPrioValue;
            while ((element = (TestElement)priorityQueue.poll()) != null) {
                Assert.assertTrue((comparator.compare(element.getPriority(), currentPriorityWatermark) >= 0 ? 1 : 0) != 0);
                currentPriorityWatermark = element.getPriority();
                if (--iterationsTillNextAdds != 0) continue;
                iterationsTillNextAdds = random.nextInt(75);
                InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, new HashSet<TestElement>(checkSet), 1 + random.nextInt(3));
                currentPriorityWatermark = ((TestElement)priorityQueue.peek()).getPriority();
            }
            Assert.assertTrue((boolean)priorityQueue.isEmpty());
            priorityQueue.addAll(checkSet);
        }
    }

    @Test
    public void testPoll() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(3);
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        Assert.assertNull((Object)priorityQueue.poll());
        int testSize = 345;
        HashSet<TestElement> checkSet = new HashSet<TestElement>(345);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 345);
        long lastPriorityValue = this.getHighestPriorityValueForComparator();
        while (!priorityQueue.isEmpty()) {
            TestElement removed = (TestElement)priorityQueue.poll();
            Assert.assertNotNull((Object)removed);
            Assert.assertTrue((boolean)checkSet.remove(removed));
            Assert.assertTrue((comparator.compare(removed.getPriority(), lastPriorityValue) >= 0 ? 1 : 0) != 0);
            lastPriorityValue = removed.getPriority();
        }
        Assert.assertTrue((boolean)checkSet.isEmpty());
        Assert.assertNull((Object)priorityQueue.poll());
    }

    @Test
    public void testIsEmpty() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        Assert.assertTrue((boolean)priorityQueue.isEmpty());
        Assert.assertTrue((boolean)priorityQueue.add((Object)new TestElement(4711L, 42L)));
        Assert.assertFalse((boolean)priorityQueue.isEmpty());
        priorityQueue.poll();
        Assert.assertTrue((boolean)priorityQueue.isEmpty());
    }

    @Test
    public void testBulkAddRestoredElements() throws Exception {
        int testSize = 10;
        HashSet<TestElement> elementSet = new HashSet<TestElement>(10);
        for (int i = 0; i < 10; ++i) {
            elementSet.add(new TestElement(i, i));
        }
        ArrayList<TestElement> twoTimesElementSet = new ArrayList<TestElement>(elementSet.size() * 2);
        for (TestElement testElement : elementSet) {
            twoTimesElementSet.add(testElement.deepCopy());
            twoTimesElementSet.add(testElement.deepCopy());
        }
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        priorityQueue.addAll(twoTimesElementSet);
        priorityQueue.addAll(elementSet);
        int expectedSize = this.testSetSemanticsAgainstDuplicateElements() ? elementSet.size() : 3 * elementSet.size();
        Assert.assertEquals((long)expectedSize, (long)priorityQueue.size());
        try (CloseableIterator iterator = priorityQueue.iterator();){
            while (iterator.hasNext()) {
                if (this.testSetSemanticsAgainstDuplicateElements()) {
                    Assert.assertTrue((boolean)elementSet.remove(iterator.next()));
                    continue;
                }
                Assert.assertTrue((boolean)elementSet.contains(iterator.next()));
            }
        }
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            Assert.assertTrue((boolean)elementSet.isEmpty());
        }
    }

    @Test
    public void testIterator() throws Exception {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        try (CloseableIterator iterator = priorityQueue.iterator();){
            Assert.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        int testSize = 10;
        HashSet<TestElement> checkSet = new HashSet<TestElement>(10);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 10);
        try (CloseableIterator iterator = priorityQueue.iterator();){
            while (iterator.hasNext()) {
                Assert.assertTrue((boolean)checkSet.remove(iterator.next()));
            }
            Assert.assertTrue((boolean)checkSet.isEmpty());
        }
    }

    @Test
    public void testAdd() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        List<TestElement> testElements = Arrays.asList(new TestElement(4711L, 42L), new TestElement(815L, 23L));
        testElements.sort((l, r) -> this.getTestElementPriorityComparator().compare(((TestElement)r).priority, ((TestElement)l).priority));
        Assert.assertTrue((boolean)priorityQueue.add((Object)testElements.get(0)));
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            priorityQueue.add((Object)testElements.get(0).deepCopy());
        }
        Assert.assertEquals((long)1L, (long)priorityQueue.size());
        Assert.assertTrue((boolean)priorityQueue.add((Object)testElements.get(1)));
        Assert.assertEquals((long)2L, (long)priorityQueue.size());
        Assert.assertEquals((Object)testElements.get(1), (Object)priorityQueue.poll());
        Assert.assertEquals((long)1L, (long)priorityQueue.size());
        Assert.assertEquals((Object)testElements.get(0), (Object)priorityQueue.poll());
        Assert.assertEquals((long)0L, (long)priorityQueue.size());
    }

    @Test
    public void testRemove() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        long key = 4711L;
        long priorityValue = 42L;
        TestElement testElement = new TestElement(4711L, 42L);
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            Assert.assertFalse((boolean)priorityQueue.remove((Object)testElement));
        }
        Assert.assertTrue((boolean)priorityQueue.add((Object)testElement));
        Assert.assertTrue((boolean)priorityQueue.remove((Object)testElement));
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            Assert.assertFalse((boolean)priorityQueue.remove((Object)testElement));
        }
        Assert.assertTrue((boolean)priorityQueue.isEmpty());
    }

    protected abstract InternalPriorityQueue<TestElement> newPriorityQueue(int var1);

    protected abstract boolean testSetSemanticsAgainstDuplicateElements();

    protected static class TestElementComparator
    implements Comparator<TestElement> {
        protected TestElementComparator() {
        }

        @Override
        public int compare(TestElement o1, TestElement o2) {
            ByteArrayOutputStreamWithPos os = new ByteArrayOutputStreamWithPos();
            DataOutputViewStreamWrapper ow = new DataOutputViewStreamWrapper((OutputStream)os);
            try {
                TestElementSerializer.INSTANCE.serialize(o1, (DataOutputView)ow);
                byte[] a1 = os.toByteArray();
                os.reset();
                TestElementSerializer.INSTANCE.serialize(o2, (DataOutputView)ow);
                byte[] a2 = os.toByteArray();
                return UnsignedBytes.lexicographicalComparator().compare(a1, a2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class TestElementSerializer
    extends TypeSerializer<TestElement> {
        private static final int REVISION = 1;
        public static final TestElementSerializer INSTANCE = new TestElementSerializer();

        protected TestElementSerializer() {
        }

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<TestElement> duplicate() {
            return this;
        }

        public TestElement createInstance() {
            throw new UnsupportedOperationException();
        }

        public TestElement copy(TestElement from) {
            return new TestElement(from.key, from.priority);
        }

        public TestElement copy(TestElement from, TestElement reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return 16;
        }

        public void serialize(TestElement record, DataOutputView target) throws IOException {
            target.writeLong(MathUtils.flipSignBit((long)record.getPriority()));
            target.writeLong(record.getKey().longValue());
        }

        public TestElement deserialize(DataInputView source) throws IOException {
            long prio = MathUtils.flipSignBit((long)source.readLong());
            long key = source.readLong();
            return new TestElement(key, prio);
        }

        public TestElement deserialize(TestElement reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.serialize(this.deserialize(source), target);
        }

        public boolean equals(Object obj) {
            return false;
        }

        public boolean canEqual(Object obj) {
            return false;
        }

        public int hashCode() {
            return 4711;
        }

        protected int getRevision() {
            return 1;
        }

        public TypeSerializerConfigSnapshot snapshotConfiguration() {
            return new Snapshot(this.getRevision());
        }

        public CompatibilityResult<TestElement> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
            return configSnapshot instanceof Snapshot && ((Snapshot)configSnapshot).revision <= this.getRevision() ? CompatibilityResult.compatible() : CompatibilityResult.requiresMigration();
        }

        public static class Snapshot
        extends TypeSerializerConfigSnapshot {
            private int revision;

            public Snapshot() {
            }

            public Snapshot(int revision) {
                this.revision = revision;
            }

            public boolean equals(Object obj) {
                return obj instanceof Snapshot && this.revision == ((Snapshot)((Object)obj)).revision;
            }

            public int hashCode() {
                return this.revision;
            }

            public int getVersion() {
                return 0;
            }

            public int getRevision() {
                return this.revision;
            }

            public void write(DataOutputView out) throws IOException {
                super.write(out);
                out.writeInt(this.revision);
            }

            public void read(DataInputView in) throws IOException {
                super.read(in);
                this.revision = in.readInt();
            }
        }
    }

    protected static class TestElement
    implements HeapPriorityQueueElement,
    Keyed<Long>,
    PriorityComparable<TestElement> {
        private final long key;
        private final long priority;
        private int internalIndex;

        public TestElement(long key, long priority) {
            this.key = key;
            this.priority = priority;
            this.internalIndex = Integer.MIN_VALUE;
        }

        public int comparePriorityTo(@Nonnull TestElement other) {
            return Long.compare(this.priority, other.priority);
        }

        public Long getKey() {
            return this.key;
        }

        public long getPriority() {
            return this.priority;
        }

        public int getInternalIndex() {
            return this.internalIndex;
        }

        public void setInternalIndex(int newIndex) {
            this.internalIndex = newIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestElement that = (TestElement)o;
            return this.key == that.key && this.priority == that.priority;
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.getPriority());
        }

        public TestElement deepCopy() {
            return new TestElement(this.key, this.priority);
        }

        public String toString() {
            return "TestElement{key=" + this.key + ", priority=" + this.priority + '}';
        }
    }
}

