/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.JavaSerializer;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.testutils.ArtificialCNFExceptionThrowingClassLoader;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FutureUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MemoryStateBackendTest
extends StateBackendTestBase<MemoryStateBackend> {
    @Override
    protected MemoryStateBackend getStateBackend() throws Exception {
        return new MemoryStateBackend(this.useAsyncMode());
    }

    protected boolean useAsyncMode() {
        return false;
    }

    @Override
    protected boolean isSerializerPresenceRequiredOnRestore() {
        return true;
    }

    @Override
    @Test
    public void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testMapStateRestoreWithWrongSerializers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperatorStateRestoreFailsIfSerializerDeserializationFails() throws Exception {
        DummyEnvironment env = new DummyEnvironment();
        MemoryStateBackend abstractStateBackend = new MemoryStateBackend(4096);
        OperatorStateBackend operatorStateBackend = abstractStateBackend.createOperatorStateBackend((Environment)env, "test-op-name");
        ListStateDescriptor stateDescriptor1 = new ListStateDescriptor("test1", (TypeSerializer)new JavaSerializer());
        ListStateDescriptor stateDescriptor2 = new ListStateDescriptor("test2", (TypeSerializer)new JavaSerializer());
        ListStateDescriptor stateDescriptor3 = new ListStateDescriptor("test3", (TypeSerializer)new JavaSerializer());
        ListState listState1 = operatorStateBackend.getListState(stateDescriptor1);
        ListState listState2 = operatorStateBackend.getListState(stateDescriptor2);
        ListState listState3 = operatorStateBackend.getUnionListState(stateDescriptor3);
        listState1.add((Object)42);
        listState1.add((Object)4711);
        listState2.add((Object)7);
        listState2.add((Object)13);
        listState2.add((Object)23);
        listState3.add((Object)17);
        listState3.add((Object)18);
        listState3.add((Object)19);
        listState3.add((Object)20);
        MemCheckpointStreamFactory streamFactory = new MemCheckpointStreamFactory(0x500000);
        RunnableFuture runnableFuture = operatorStateBackend.snapshot(1L, 1L, (CheckpointStreamFactory)streamFactory, CheckpointOptions.forCheckpointWithDefaultLocation());
        SnapshotResult snapshotResult = (SnapshotResult)FutureUtil.runIfNotDoneAndGet((RunnableFuture)runnableFuture);
        OperatorStateHandle stateHandle = (OperatorStateHandle)snapshotResult.getJobManagerOwnedSnapshot();
        try {
            operatorStateBackend.close();
            operatorStateBackend.dispose();
            env = new DummyEnvironment((ClassLoader)new ArtificialCNFExceptionThrowingClassLoader(((Object)((Object)this)).getClass().getClassLoader(), Collections.singleton(JavaSerializer.class.getName())));
            operatorStateBackend = abstractStateBackend.createOperatorStateBackend((Environment)env, "testOperator");
            operatorStateBackend.restore((Object)StateObjectCollection.singleton((StateObject)stateHandle));
            Assert.fail((String)"The operator state restore should have failed if the previous state serializer could not be loaded.");
        }
        catch (Exception expected) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)expected, ClassNotFoundException.class).isPresent());
        }
        finally {
            stateHandle.discardState();
        }
    }

    @Test
    public void testKeyedStateRestoreFailsIfSerializerDeserializationFails() throws Exception {
        CheckpointStreamFactory streamFactory = this.createStreamFactory();
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        AbstractKeyedStateBackend backend = this.createKeyedBackend(IntSerializer.INSTANCE);
        ValueStateDescriptor kvId = new ValueStateDescriptor("id", String.class, null);
        kvId.initializeSerializerUnlessSet(new ExecutionConfig());
        HeapKeyedStateBackend heapBackend = (HeapKeyedStateBackend)backend;
        Assert.assertEquals((long)0L, (long)heapBackend.numKeyValueStateEntries());
        ValueState state = (ValueState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)kvId);
        backend.setCurrentKey((Object)0);
        state.update((Object)"hello");
        state.update((Object)"ciao");
        KeyedStateHandle snapshot = this.runSnapshot(((HeapKeyedStateBackend)backend).snapshot(682375462378L, 2L, streamFactory, CheckpointOptions.forCheckpointWithDefaultLocation()), sharedStateRegistry);
        backend.dispose();
        try {
            this.restoreKeyedBackend(IntSerializer.INSTANCE, snapshot, new DummyEnvironment((ClassLoader)new ArtificialCNFExceptionThrowingClassLoader(((Object)((Object)this)).getClass().getClassLoader(), Collections.singleton(StringSerializer.class.getName()))));
            Assert.fail((String)"The keyed state restore should have failed if the previous state serializer could not be loaded.");
        }
        catch (Exception expected) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)expected, ClassNotFoundException.class).isPresent());
        }
    }

    @Override
    @Ignore
    @Test
    public void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

