/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PrioritizedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.TestCheckpointResponder;
import org.apache.flink.util.Preconditions;

public class TestTaskStateManager
implements TaskStateManager {
    private long reportedCheckpointId;
    private JobID jobId;
    private ExecutionAttemptID executionAttemptID;
    private final Map<Long, TaskStateSnapshot> jobManagerTaskStateSnapshotsByCheckpointId;
    private final Map<Long, TaskStateSnapshot> taskManagerTaskStateSnapshotsByCheckpointId;
    private CheckpointResponder checkpointResponder;
    private OneShotLatch waitForReportLatch;
    private LocalRecoveryConfig localRecoveryDirectoryProvider;

    public TestTaskStateManager() {
        this(TestLocalRecoveryConfig.disabled());
    }

    public TestTaskStateManager(LocalRecoveryConfig localRecoveryConfig) {
        this(new JobID(), new ExecutionAttemptID(), new TestCheckpointResponder(), localRecoveryConfig);
    }

    public TestTaskStateManager(JobID jobId, ExecutionAttemptID executionAttemptID) {
        this(jobId, executionAttemptID, null, TestLocalRecoveryConfig.disabled());
    }

    public TestTaskStateManager(JobID jobId, ExecutionAttemptID executionAttemptID, CheckpointResponder checkpointResponder, LocalRecoveryConfig localRecoveryConfig) {
        this.jobId = jobId;
        this.executionAttemptID = executionAttemptID;
        this.checkpointResponder = checkpointResponder;
        this.localRecoveryDirectoryProvider = localRecoveryConfig;
        this.jobManagerTaskStateSnapshotsByCheckpointId = new HashMap<Long, TaskStateSnapshot>();
        this.taskManagerTaskStateSnapshotsByCheckpointId = new HashMap<Long, TaskStateSnapshot>();
        this.reportedCheckpointId = -1L;
    }

    public void reportTaskStateSnapshots(@Nonnull CheckpointMetaData checkpointMetaData, @Nonnull CheckpointMetrics checkpointMetrics, @Nullable TaskStateSnapshot acknowledgedState, @Nullable TaskStateSnapshot localState) {
        this.jobManagerTaskStateSnapshotsByCheckpointId.put(checkpointMetaData.getCheckpointId(), acknowledgedState);
        this.taskManagerTaskStateSnapshotsByCheckpointId.put(checkpointMetaData.getCheckpointId(), localState);
        if (this.checkpointResponder != null) {
            this.checkpointResponder.acknowledgeCheckpoint(this.jobId, this.executionAttemptID, checkpointMetaData.getCheckpointId(), checkpointMetrics, acknowledgedState);
        }
        this.reportedCheckpointId = checkpointMetaData.getCheckpointId();
        if (this.waitForReportLatch != null) {
            this.waitForReportLatch.trigger();
        }
    }

    @Nonnull
    public PrioritizedOperatorSubtaskState prioritizedOperatorState(OperatorID operatorID) {
        OperatorSubtaskState tmOpState;
        TaskStateSnapshot jmTaskStateSnapshot = this.getLastJobManagerTaskStateSnapshot();
        TaskStateSnapshot tmTaskStateSnapshot = this.getLastTaskManagerTaskStateSnapshot();
        if (jmTaskStateSnapshot == null) {
            return PrioritizedOperatorSubtaskState.emptyNotRestored();
        }
        OperatorSubtaskState jmOpState = jmTaskStateSnapshot.getSubtaskStateByOperatorID(operatorID);
        if (jmOpState == null) {
            return PrioritizedOperatorSubtaskState.emptyNotRestored();
        }
        List<Object> tmStateCollection = Collections.emptyList();
        if (tmTaskStateSnapshot != null && (tmOpState = tmTaskStateSnapshot.getSubtaskStateByOperatorID(operatorID)) != null) {
            tmStateCollection = Collections.singletonList(tmOpState);
        }
        PrioritizedOperatorSubtaskState.Builder builder = new PrioritizedOperatorSubtaskState.Builder(jmOpState, tmStateCollection);
        return builder.build();
    }

    @Nonnull
    public LocalRecoveryConfig createLocalRecoveryConfig() {
        return (LocalRecoveryConfig)Preconditions.checkNotNull((Object)this.localRecoveryDirectoryProvider, (String)"Local state directory was never set for this test object!");
    }

    public void setLocalRecoveryConfig(LocalRecoveryConfig recoveryDirectoryProvider) {
        this.localRecoveryDirectoryProvider = recoveryDirectoryProvider;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public void setJobId(JobID jobId) {
        this.jobId = jobId;
    }

    public ExecutionAttemptID getExecutionAttemptID() {
        return this.executionAttemptID;
    }

    public void setExecutionAttemptID(ExecutionAttemptID executionAttemptID) {
        this.executionAttemptID = executionAttemptID;
    }

    public CheckpointResponder getCheckpointResponder() {
        return this.checkpointResponder;
    }

    public void setCheckpointResponder(CheckpointResponder checkpointResponder) {
        this.checkpointResponder = checkpointResponder;
    }

    public Map<Long, TaskStateSnapshot> getJobManagerTaskStateSnapshotsByCheckpointId() {
        return this.jobManagerTaskStateSnapshotsByCheckpointId;
    }

    public void setJobManagerTaskStateSnapshotsByCheckpointId(Map<Long, TaskStateSnapshot> jobManagerTaskStateSnapshotsByCheckpointId) {
        this.jobManagerTaskStateSnapshotsByCheckpointId.clear();
        this.jobManagerTaskStateSnapshotsByCheckpointId.putAll(jobManagerTaskStateSnapshotsByCheckpointId);
    }

    public Map<Long, TaskStateSnapshot> getTaskManagerTaskStateSnapshotsByCheckpointId() {
        return this.taskManagerTaskStateSnapshotsByCheckpointId;
    }

    public void setTaskManagerTaskStateSnapshotsByCheckpointId(Map<Long, TaskStateSnapshot> taskManagerTaskStateSnapshotsByCheckpointId) {
        this.taskManagerTaskStateSnapshotsByCheckpointId.clear();
        this.taskManagerTaskStateSnapshotsByCheckpointId.putAll(taskManagerTaskStateSnapshotsByCheckpointId);
    }

    public long getReportedCheckpointId() {
        return this.reportedCheckpointId;
    }

    public void setReportedCheckpointId(long reportedCheckpointId) {
        this.reportedCheckpointId = reportedCheckpointId;
    }

    public TaskStateSnapshot getLastJobManagerTaskStateSnapshot() {
        return this.jobManagerTaskStateSnapshotsByCheckpointId != null ? this.jobManagerTaskStateSnapshotsByCheckpointId.get(this.reportedCheckpointId) : null;
    }

    public TaskStateSnapshot getLastTaskManagerTaskStateSnapshot() {
        return this.taskManagerTaskStateSnapshotsByCheckpointId != null ? this.taskManagerTaskStateSnapshotsByCheckpointId.get(this.reportedCheckpointId) : null;
    }

    public OneShotLatch getWaitForReportLatch() {
        return this.waitForReportLatch;
    }

    public void setWaitForReportLatch(OneShotLatch waitForReportLatch) {
        this.waitForReportLatch = waitForReportLatch;
    }

    public void restoreLatestCheckpointState(Map<Long, TaskStateSnapshot> taskStateSnapshotsByCheckpointId) {
        if (taskStateSnapshotsByCheckpointId == null || taskStateSnapshotsByCheckpointId.isEmpty()) {
            return;
        }
        long latestId = -1L;
        for (long id : taskStateSnapshotsByCheckpointId.keySet()) {
            if (id <= latestId) continue;
            latestId = id;
        }
        this.setReportedCheckpointId(latestId);
        this.setJobManagerTaskStateSnapshotsByCheckpointId(taskStateSnapshotsByCheckpointId);
    }
}

