/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public abstract class HeapStateBackendTestBase {
    @Parameterized.Parameter
    public boolean async;

    @Parameterized.Parameters
    public static Collection<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    public HeapKeyedStateBackend<String> createKeyedBackend() throws Exception {
        return this.createKeyedBackend((TypeSerializer)StringSerializer.INSTANCE);
    }

    public <K> HeapKeyedStateBackend<K> createKeyedBackend(TypeSerializer<K> keySerializer) throws Exception {
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 15);
        int numKeyGroups = keyGroupRange.getNumberOfKeyGroups();
        return new HeapKeyedStateBackend((TaskKvStateRegistry)Mockito.mock(TaskKvStateRegistry.class), keySerializer, HeapStateBackendTestBase.class.getClassLoader(), numKeyGroups, keyGroupRange, this.async, new ExecutionConfig(), TestLocalRecoveryConfig.disabled(), new HeapPriorityQueueSetFactory(keyGroupRange, numKeyGroups, 128), TtlTimeProvider.DEFAULT);
    }
}

