/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.KeyGroupPartitionerTestBase;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateTable;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateTableSnapshot;

public class StateTableKeyGroupPartitionerTest
extends KeyGroupPartitionerTestBase<CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer>> {
    public StateTableKeyGroupPartitionerTest() {
        super(random -> StateTableKeyGroupPartitionerTest.generateElement(random, null), CopyOnWriteStateTable.StateTableEntry::getKey);
    }

    protected CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer>[] generateTestInput(Random random, int numElementsToGenerate, Set<CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer>> allElementsIdentitySet) {
        int arraySize = numElementsToGenerate > 1 ? numElementsToGenerate + 5 : numElementsToGenerate;
        CopyOnWriteStateTable.StateTableEntry[] data = new CopyOnWriteStateTable.StateTableEntry[arraySize];
        while (numElementsToGenerate > 0) {
            int generateAsChainCount = Math.min(1 + random.nextInt(3), numElementsToGenerate);
            CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer> element = null;
            for (int i = 0; i < generateAsChainCount; ++i) {
                element = StateTableKeyGroupPartitionerTest.generateElement(random, element);
                allElementsIdentitySet.add(element);
            }
            data[data.length - numElementsToGenerate + random.nextInt((int)generateAsChainCount)] = element;
            numElementsToGenerate -= generateAsChainCount;
        }
        return data;
    }

    protected KeyGroupPartitioner<CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer>> createPartitioner(CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer>[] data, int numElements, KeyGroupRange keyGroupRange, int totalKeyGroups, KeyGroupPartitioner.ElementWriterFunction<CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer>> elementWriterFunction) {
        return new CopyOnWriteStateTableSnapshot.StateTableKeyGroupPartitioner(data, numElements, keyGroupRange, totalKeyGroups, elementWriterFunction);
    }

    private static CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer> generateElement(@Nonnull Random random, @Nullable CopyOnWriteStateTable.StateTableEntry<Integer, VoidNamespace, Integer> next) {
        Integer generatedKey = random.nextInt() & Integer.MAX_VALUE;
        return new CopyOnWriteStateTable.StateTableEntry((Object)generatedKey, (Object)VoidNamespace.INSTANCE, (Object)random.nextInt(), generatedKey.hashCode(), next, 0, 0);
    }
}

