/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.RunnableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.util.Preconditions;

public abstract class StateBackendTestContext {
    private final StateBackend stateBackend;
    private final CheckpointStorageLocation checkpointStorageLocation;
    private final TtlTimeProvider timeProvider;
    private AbstractKeyedStateBackend<String> keyedStateBackend;

    protected StateBackendTestContext(TtlTimeProvider timeProvider) {
        this.timeProvider = (TtlTimeProvider)Preconditions.checkNotNull((Object)timeProvider);
        this.stateBackend = (StateBackend)Preconditions.checkNotNull((Object)this.createStateBackend());
        this.checkpointStorageLocation = this.createCheckpointStorageLocation();
    }

    protected abstract StateBackend createStateBackend();

    private CheckpointStorageLocation createCheckpointStorageLocation() {
        try {
            return this.stateBackend.createCheckpointStorage(new JobID()).initializeLocationForCheckpoint(2L);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected");
        }
    }

    void createAndRestoreKeyedStateBackend() {
        DummyEnvironment env = new DummyEnvironment();
        try {
            this.disposeKeyedStateBackend();
            this.keyedStateBackend = this.stateBackend.createKeyedStateBackend((Environment)env, new JobID(), "test", (TypeSerializer)StringSerializer.INSTANCE, 10, new KeyGroupRange(0, 9), env.getTaskKvStateRegistry(), this.timeProvider);
            this.keyedStateBackend.setCurrentKey((Object)"defaultKey");
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected");
        }
    }

    void disposeKeyedStateBackend() {
        if (this.keyedStateBackend != null) {
            this.keyedStateBackend.dispose();
            this.keyedStateBackend = null;
        }
    }

    @Nonnull
    KeyedStateHandle takeSnapshot() throws Exception {
        RunnableFuture snapshotRunnableFuture = this.keyedStateBackend.snapshot(682375462392L, 10L, (CheckpointStreamFactory)this.checkpointStorageLocation, CheckpointOptions.forCheckpointWithDefaultLocation());
        if (!snapshotRunnableFuture.isDone()) {
            snapshotRunnableFuture.run();
        }
        return (KeyedStateHandle)((SnapshotResult)snapshotRunnableFuture.get()).getJobManagerOwnedSnapshot();
    }

    void restoreSnapshot(@Nullable KeyedStateHandle snapshot) throws Exception {
        StateObjectCollection restoreState = snapshot == null ? null : new StateObjectCollection(Collections.singleton(snapshot));
        this.keyedStateBackend.restore((Object)restoreState);
        if (snapshot != null) {
            snapshot.discardState();
        }
    }

    void setCurrentKey(String key) {
        Preconditions.checkNotNull(this.keyedStateBackend, (String)"keyed backend is not initialised");
        this.keyedStateBackend.setCurrentKey((Object)key);
    }

    <N, S extends State, V> S createState(StateDescriptor<S, V> stateDescriptor, N defaultNamespace) throws Exception {
        State state = this.keyedStateBackend.getOrCreateKeyedState((TypeSerializer)StringSerializer.INSTANCE, stateDescriptor);
        ((InternalKvState)state).setCurrentNamespace(defaultNamespace);
        return (S)state;
    }
}

