/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.ttl.TtlAggregatingState;
import org.apache.flink.runtime.state.ttl.TtlMergingStateTestContext;

class TtlAggregatingStateTestContext
extends TtlMergingStateTestContext.TtlIntegerMergingStateTestContext<TtlAggregatingState<?, String, Integer, Long, String>, Integer, String> {
    private static final long DEFAULT_ACCUMULATOR = 3L;
    private static final AggregateFunction<Integer, Long, String> AGGREGATE = new AggregateFunction<Integer, Long, String>(){

        public Long createAccumulator() {
            return 3L;
        }

        public Long add(Integer value, Long accumulator) {
            return accumulator + (long)value.intValue();
        }

        public String getResult(Long accumulator) {
            return accumulator.toString();
        }

        public Long merge(Long a, Long b) {
            return a + b;
        }
    };

    TtlAggregatingStateTestContext() {
    }

    @Override
    void initTestValues() {
        this.updateEmpty = 5;
        this.updateUnexpired = 7;
        this.updateExpired = 6;
        this.getUpdateEmpty = "8";
        this.getUnexpired = "15";
        this.getUpdateExpired = "9";
    }

    @Override
    <US extends State, SV> StateDescriptor<US, SV> createStateDescriptor() {
        return new AggregatingStateDescriptor("TtlTestAggregatingState", AGGREGATE, (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Override
    void update(Integer value) throws Exception {
        ((TtlAggregatingState)this.ttlState).add((Object)value);
    }

    @Override
    String get() throws Exception {
        return (String)((TtlAggregatingState)this.ttlState).get();
    }

    @Override
    Object getOriginal() throws Exception {
        return ((InternalAggregatingState)((TtlAggregatingState)this.ttlState).original).get();
    }

    @Override
    String getMergeResult(List<Tuple2<String, Integer>> unexpiredUpdatesToMerge, List<Tuple2<String, Integer>> finalUpdatesToMerge) {
        HashSet namespaces = new HashSet();
        unexpiredUpdatesToMerge.forEach(t -> namespaces.add(t.f0));
        finalUpdatesToMerge.forEach(t -> namespaces.add(t.f0));
        return Integer.toString(this.getIntegerMergeResult(unexpiredUpdatesToMerge, finalUpdatesToMerge) + namespaces.size() * 3);
    }
}

