/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.StackTraceSampleResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.types.SerializableOptional;
import org.apache.flink.util.Preconditions;

public class TestingTaskExecutorGateway
implements TaskExecutorGateway {
    private final String address;
    private final String hostname;
    private final Consumer<ResourceID> heartbeatJobManagerConsumer;
    private final BiConsumer<JobID, Throwable> disconnectJobManagerConsumer;
    private final BiFunction<TaskDeploymentDescriptor, JobMasterId, CompletableFuture<Acknowledge>> submitTaskConsumer;
    private final Function<Tuple5<SlotID, JobID, AllocationID, String, ResourceManagerId>, CompletableFuture<Acknowledge>> requestSlotFunction;
    private final BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction;

    TestingTaskExecutorGateway(String address, String hostname, Consumer<ResourceID> heartbeatJobManagerConsumer, BiConsumer<JobID, Throwable> disconnectJobManagerConsumer, BiFunction<TaskDeploymentDescriptor, JobMasterId, CompletableFuture<Acknowledge>> submitTaskConsumer, Function<Tuple5<SlotID, JobID, AllocationID, String, ResourceManagerId>, CompletableFuture<Acknowledge>> requestSlotFunction, BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction) {
        this.address = (String)Preconditions.checkNotNull((Object)address);
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.heartbeatJobManagerConsumer = (Consumer)Preconditions.checkNotNull(heartbeatJobManagerConsumer);
        this.disconnectJobManagerConsumer = (BiConsumer)Preconditions.checkNotNull(disconnectJobManagerConsumer);
        this.submitTaskConsumer = (BiFunction)Preconditions.checkNotNull(submitTaskConsumer);
        this.requestSlotFunction = (Function)Preconditions.checkNotNull(requestSlotFunction);
        this.freeSlotFunction = (BiFunction)Preconditions.checkNotNull(freeSlotFunction);
    }

    public CompletableFuture<Acknowledge> requestSlot(SlotID slotId, JobID jobId, AllocationID allocationId, String targetAddress, ResourceManagerId resourceManagerId, Time timeout) {
        return this.requestSlotFunction.apply((Tuple5<SlotID, JobID, AllocationID, String, ResourceManagerId>)Tuple5.of((Object)slotId, (Object)jobId, (Object)allocationId, (Object)targetAddress, (Object)resourceManagerId));
    }

    public CompletableFuture<StackTraceSampleResponse> requestStackTraceSample(ExecutionAttemptID executionAttemptId, int sampleId, int numSamples, Time delayBetweenSamples, int maxStackTraceDepth, Time timeout) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, JobMasterId jobMasterId, Time timeout) {
        return this.submitTaskConsumer.apply(tdd, jobMasterId);
    }

    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void failPartition(ExecutionAttemptID executionAttemptID) {
    }

    public CompletableFuture<Acknowledge> triggerCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointID, long checkpointTimestamp, CheckpointOptions checkpointOptions) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> confirmCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointId, long checkpointTimestamp) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> stopTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void heartbeatFromJobManager(ResourceID heartbeatOrigin) {
        this.heartbeatJobManagerConsumer.accept(heartbeatOrigin);
    }

    public void heartbeatFromResourceManager(ResourceID heartbeatOrigin) {
    }

    public void disconnectJobManager(JobID jobId, Exception cause) {
        this.disconnectJobManagerConsumer.accept(jobId, cause);
    }

    public void disconnectResourceManager(Exception cause) {
    }

    public CompletableFuture<Acknowledge> freeSlot(AllocationID allocationId, Throwable cause, Time timeout) {
        return this.freeSlotFunction.apply(allocationId, cause);
    }

    public CompletableFuture<TransientBlobKey> requestFileUpload(FileType fileType, Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<SerializableOptional<String>> requestMetricQueryServiceAddress(Time timeout) {
        return CompletableFuture.completedFuture(SerializableOptional.of((Serializable)((Object)this.address)));
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }
}

