/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.IteratorUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotFoundException;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TestingSlotActionsBuilder;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TaskSlotTableTest
extends TestLogger {
    private static final Time SLOT_TIMEOUT = Time.seconds((long)100L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTryMarkSlotActive() throws SlotNotFoundException {
        TaskSlotTable taskSlotTable = this.createTaskSlotTable(Collections.nCopies(3, ResourceProfile.UNKNOWN));
        try {
            taskSlotTable.start((SlotActions)new TestingSlotActionsBuilder().build());
            JobID jobId1 = new JobID();
            AllocationID allocationId1 = new AllocationID();
            taskSlotTable.allocateSlot(0, jobId1, allocationId1, SLOT_TIMEOUT);
            AllocationID allocationId2 = new AllocationID();
            taskSlotTable.allocateSlot(1, jobId1, allocationId2, SLOT_TIMEOUT);
            AllocationID allocationId3 = new AllocationID();
            JobID jobId2 = new JobID();
            taskSlotTable.allocateSlot(2, jobId2, allocationId3, SLOT_TIMEOUT);
            taskSlotTable.markSlotActive(allocationId1);
            Assert.assertThat((Object)taskSlotTable.isAllocated(0, jobId1, allocationId1), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.isAllocated(1, jobId1, allocationId2), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.isAllocated(2, jobId2, allocationId3), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)IteratorUtils.toList((Iterator)taskSlotTable.getActiveSlots(jobId1)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(Arrays.asList(allocationId1))));
            Assert.assertThat((Object)taskSlotTable.tryMarkSlotActive(jobId1, allocationId1), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.tryMarkSlotActive(jobId1, allocationId2), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.tryMarkSlotActive(jobId1, allocationId3), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)Sets.newHashSet((Iterator)taskSlotTable.getActiveSlots(jobId1)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(new HashSet<AllocationID>(Arrays.asList(allocationId2, allocationId1)))));
        }
        finally {
            taskSlotTable.stop();
        }
    }

    @Nonnull
    private TaskSlotTable createTaskSlotTable(Collection<ResourceProfile> resourceProfiles) {
        return new TaskSlotTable(resourceProfiles, new TimerService(TestingUtils.defaultExecutor(), 10000L));
    }
}

