/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraph;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;

public class InMemorySubmittedJobGraphStore
implements SubmittedJobGraphStore {
    private final Map<JobID, SubmittedJobGraph> storedJobs = new HashMap<JobID, SubmittedJobGraph>();
    private boolean started;
    private volatile FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction = null;
    private volatile BiFunctionWithException<JobID, Map<JobID, SubmittedJobGraph>, SubmittedJobGraph, ? extends Exception> recoverJobGraphFunction = null;

    public void setJobIdsFunction(FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction) {
        this.jobIdsFunction = (FunctionWithException)Preconditions.checkNotNull(jobIdsFunction);
    }

    public void setRecoverJobGraphFunction(BiFunctionWithException<JobID, Map<JobID, SubmittedJobGraph>, SubmittedJobGraph, ? extends Exception> recoverJobGraphFunction) {
        this.recoverJobGraphFunction = (BiFunctionWithException)Preconditions.checkNotNull(recoverJobGraphFunction);
    }

    public synchronized void start(@Nullable SubmittedJobGraphStore.SubmittedJobGraphListener jobGraphListener) throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }

    public synchronized SubmittedJobGraph recoverJobGraph(JobID jobId) throws Exception {
        this.verifyIsStarted();
        if (this.recoverJobGraphFunction != null) {
            return (SubmittedJobGraph)this.recoverJobGraphFunction.apply((Object)jobId, this.storedJobs);
        }
        return Objects.requireNonNull(this.storedJobs.get(jobId), "Job graph for job " + jobId + " does not exist");
    }

    public synchronized void putJobGraph(SubmittedJobGraph jobGraph) throws Exception {
        this.verifyIsStarted();
        this.storedJobs.put(jobGraph.getJobId(), jobGraph);
    }

    public synchronized void removeJobGraph(JobID jobId) throws Exception {
        this.verifyIsStarted();
        this.storedJobs.remove(jobId);
    }

    public void releaseJobGraph(JobID jobId) {
        this.verifyIsStarted();
    }

    public synchronized Collection<JobID> getJobIds() throws Exception {
        this.verifyIsStarted();
        if (this.jobIdsFunction != null) {
            return (Collection)this.jobIdsFunction.apply(this.storedJobs.keySet());
        }
        return Collections.unmodifiableSet(new HashSet<JobID>(this.storedJobs.keySet()));
    }

    public synchronized boolean contains(JobID jobId) {
        this.verifyIsStarted();
        return this.storedJobs.containsKey(jobId);
    }

    private void verifyIsStarted() {
        Preconditions.checkState((boolean)this.started, (Object)"Not running. Forgot to call start()?");
    }
}

