/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniClusterResource
extends ExternalResource {
    private static final String DEFAULT_MANAGED_MEMORY_SIZE = "80m";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final MiniClusterResourceConfiguration miniClusterResourceConfiguration;
    private MiniCluster miniCluster = null;
    private int numberSlots = -1;
    private UnmodifiableConfiguration restClusterClientConfig;

    public MiniClusterResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        this.miniClusterResourceConfiguration = (MiniClusterResourceConfiguration)Preconditions.checkNotNull((Object)miniClusterResourceConfiguration);
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public MiniCluster getMiniCluster() {
        return this.miniCluster;
    }

    public UnmodifiableConfiguration getClientConfiguration() {
        return this.restClusterClientConfig;
    }

    public URI getRestAddres() {
        return this.miniCluster.getRestAddress();
    }

    public void before() throws Exception {
        this.temporaryFolder.create();
        this.startMiniCluster();
        this.numberSlots = this.miniClusterResourceConfiguration.getNumberSlotsPerTaskManager() * this.miniClusterResourceConfiguration.getNumberTaskManagers();
    }

    public void after() {
        this.temporaryFolder.delete();
        Exception exception = null;
        if (this.miniCluster != null) {
            CompletableFuture terminationFuture = this.miniCluster.closeAsync();
            try {
                terminationFuture.get(this.miniClusterResourceConfiguration.getShutdownTimeout().toMilliseconds(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
            this.miniCluster = null;
        }
        if (exception != null) {
            this.log.warn("Could not properly shut down the MiniClusterResource.", exception);
        }
    }

    private void startMiniCluster() throws Exception {
        Configuration configuration = new Configuration(this.miniClusterResourceConfiguration.getConfiguration());
        configuration.setString(CoreOptions.TMP_DIRS, this.temporaryFolder.newFolder().getAbsolutePath());
        if (!configuration.contains(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE)) {
            configuration.setBoolean(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE, true);
        }
        if (!configuration.contains(TaskManagerOptions.MANAGED_MEMORY_SIZE)) {
            configuration.setString(TaskManagerOptions.MANAGED_MEMORY_SIZE, DEFAULT_MANAGED_MEMORY_SIZE);
        }
        configuration.setInteger(JobManagerOptions.PORT, 0);
        configuration.setInteger(RestOptions.PORT, 0);
        MiniClusterConfiguration miniClusterConfiguration = new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(this.miniClusterResourceConfiguration.getNumberTaskManagers()).setNumSlotsPerTaskManager(this.miniClusterResourceConfiguration.getNumberSlotsPerTaskManager()).build();
        this.miniCluster = new MiniCluster(miniClusterConfiguration);
        this.miniCluster.start();
        URI restAddress = this.miniCluster.getRestAddress();
        this.createClientConfiguration(restAddress);
    }

    private void createClientConfiguration(URI restAddress) {
        Configuration restClientConfig = new Configuration();
        restClientConfig.setString(JobManagerOptions.ADDRESS, restAddress.getHost());
        restClientConfig.setInteger(RestOptions.PORT, restAddress.getPort());
        this.restClusterClientConfig = new UnmodifiableConfiguration(restClientConfig);
    }
}

