/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils.recordutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Record;

public final class RecordSerializer
extends TypeSerializer<Record> {
    private static final long serialVersionUID = 1L;
    private static final RecordSerializer INSTANCE = new RecordSerializer();
    private static final int MAX_BIT = 128;

    public static RecordSerializer get() {
        return INSTANCE;
    }

    private RecordSerializer() {
    }

    public boolean isImmutableType() {
        return false;
    }

    public RecordSerializer duplicate() {
        return this;
    }

    public Record createInstance() {
        return new Record();
    }

    public Record copy(Record from) {
        return from.createCopy();
    }

    public Record copy(Record from, Record reuse) {
        from.copyTo(reuse);
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Record record, DataOutputView target) throws IOException {
        record.serialize(target);
    }

    public Record deserialize(DataInputView source) throws IOException {
        return this.deserialize(new Record(), source);
    }

    public Record deserialize(Record target, DataInputView source) throws IOException {
        target.deserialize(source);
        return target;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int val = source.readUnsignedByte();
        target.writeByte(val);
        if (val >= 128) {
            int curr;
            int shift = 7;
            val &= 0x7F;
            while ((curr = source.readUnsignedByte()) >= 128) {
                target.writeByte(curr);
                val |= (curr & 0x7F) << shift;
                shift += 7;
            }
            target.writeByte(curr);
            val |= curr << shift;
        }
        target.write(source, val);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecordSerializer) {
            RecordSerializer other = (RecordSerializer)((Object)obj);
            return other.canEqual((Object)this);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof RecordSerializer;
    }

    public int hashCode() {
        return RecordSerializer.class.hashCode();
    }

    public TypeSerializerConfigSnapshot<Record> snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }

    public CompatibilityResult<Record> ensureCompatibility(TypeSerializerConfigSnapshot<?> configSnapshot) {
        throw new UnsupportedOperationException();
    }
}

