/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.junit.Assert;
import org.junit.Test;

public class EvictingBoundedListTest {
    @Test
    public void testAddGet() {
        int i;
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        Assert.assertTrue((boolean)list.isEmpty());
        for (i = 0; i < insertSize; ++i) {
            list.add((Object)i);
        }
        Assert.assertEquals((long)17L, (long)list.size());
        for (i = 0; i < insertSize; ++i) {
            int exp = i < insertSize - boundSize ? defaultElement : i;
            int act = (Integer)list.get(i);
            Assert.assertEquals((long)exp, (long)act);
        }
    }

    @Test
    public void testSet() {
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        ArrayList<Integer> reference = new ArrayList<Integer>(insertSize);
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        for (int i = 0; i < insertSize; ++i) {
            reference.add(i);
            list.add((Object)i);
        }
        Assert.assertEquals((long)reference.size(), (long)list.size());
        list.set(0, (Object)123);
        list.set(insertSize - boundSize - 1, (Object)123);
        list.set(insertSize - boundSize, (Object)42);
        reference.set(insertSize - boundSize, 42);
        list.set(13, (Object)43);
        reference.set(13, 43);
        list.set(16, (Object)44);
        reference.set(16, 44);
        try {
            list.set(insertSize, (Object)23);
            Assert.fail((String)"Illegal index in set not detected.");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        for (int i = 0; i < insertSize; ++i) {
            int exp = i < insertSize - boundSize ? defaultElement.intValue() : ((Integer)reference.get(i)).intValue();
            int act = (Integer)list.get(i);
            Assert.assertEquals((long)exp, (long)act);
        }
        Assert.assertEquals((long)reference.size(), (long)list.size());
    }

    @Test
    public void testClear() {
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        for (int i = 0; i < insertSize; ++i) {
            list.add((Object)i);
        }
        list.clear();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertTrue((boolean)list.isEmpty());
        try {
            list.get(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIterator() {
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        Assert.assertTrue((boolean)list.isEmpty());
        for (int i = 0; i < insertSize; ++i) {
            list.add((Object)i);
        }
        Iterator iterator = list.iterator();
        for (int i = 0; i < insertSize; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            int exp = i < insertSize - boundSize ? defaultElement : i;
            int act = (Integer)iterator.next();
            Assert.assertEquals((long)exp, (long)act);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Next on exhausted iterator did not trigger exception.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        iterator = list.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        list.add((Object)123);
        Assert.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Concurrent modification not detected.");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }
}

