/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.TransientBlobCache;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.netty.PartitionProducerStateChecker;
import org.apache.flink.runtime.io.network.partition.NoOpResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.TaskLocalStateStore;
import org.apache.flink.runtime.state.TaskLocalStateStoreImpl;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TaskStateManagerImpl;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.NoOpTaskManagerActions;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.SerializedValue;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class JvmExitOnFatalErrorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testExitJvmOnOutOfMemory() throws Exception {
        Assume.assumeTrue((boolean)OperatingSystem.isLinux());
        KillOnFatalErrorProcess testProcess = new KillOnFatalErrorProcess();
        try {
            testProcess.startProcess();
            testProcess.waitFor();
        }
        finally {
            testProcess.destroy();
        }
    }

    public static final class ProcessEntryPoint {
        public static void main(String[] args) throws Exception {
            System.err.println("creating task");
            try {
                Configuration taskManagerConfig = new Configuration();
                taskManagerConfig.setBoolean(TaskManagerOptions.KILL_ON_OUT_OF_MEMORY, true);
                JobID jid = new JobID();
                AllocationID allocationID = new AllocationID();
                JobVertexID jobVertexId = new JobVertexID();
                ExecutionAttemptID executionAttemptID = new ExecutionAttemptID();
                AllocationID slotAllocationId = new AllocationID();
                SerializedValue execConfig = new SerializedValue((Object)new ExecutionConfig());
                JobInformation jobInformation = new JobInformation(jid, "Test Job", execConfig, new Configuration(), Collections.emptyList(), Collections.emptyList());
                TaskInformation taskInformation = new TaskInformation(jobVertexId, "Test Task", 1, 1, OomInvokable.class.getName(), new Configuration());
                MemoryManager memoryManager = new MemoryManager(0x100000L, 1);
                IOManagerAsync ioManager = new IOManagerAsync();
                NetworkEnvironment networkEnvironment = (NetworkEnvironment)Mockito.mock(NetworkEnvironment.class);
                Mockito.when((Object)networkEnvironment.createKvStateTaskRegistry(jid, jobVertexId)).thenReturn(Mockito.mock(TaskKvStateRegistry.class));
                TaskEventDispatcher taskEventDispatcher = (TaskEventDispatcher)Mockito.mock(TaskEventDispatcher.class);
                Mockito.when((Object)networkEnvironment.getTaskEventDispatcher()).thenReturn((Object)taskEventDispatcher);
                TaskManagerConfiguration tmInfo = TaskManagerConfiguration.fromConfiguration((Configuration)taskManagerConfig);
                ExecutorService executor = Executors.newCachedThreadPool();
                BlobCacheService blobService = new BlobCacheService((PermanentBlobCache)Mockito.mock(PermanentBlobCache.class), (TransientBlobCache)Mockito.mock(TransientBlobCache.class));
                TaskLocalStateStoreImpl localStateStore = new TaskLocalStateStoreImpl(jid, allocationID, jobVertexId, 0, TestLocalRecoveryConfig.disabled(), (Executor)executor);
                TaskStateManagerImpl slotStateManager = new TaskStateManagerImpl(jid, executionAttemptID, (TaskLocalStateStore)localStateStore, null, (CheckpointResponder)Mockito.mock(CheckpointResponder.class));
                Task task = new Task(jobInformation, taskInformation, executionAttemptID, slotAllocationId, 0, 0, Collections.emptyList(), Collections.emptyList(), 0, memoryManager, (IOManager)ioManager, networkEnvironment, new BroadcastVariableManager(), (TaskStateManager)slotStateManager, (TaskManagerActions)new NoOpTaskManagerActions(), (InputSplitProvider)new NoOpInputSplitProvider(), (CheckpointResponder)new NoOpCheckpointResponder(), blobService, (LibraryCacheManager)new BlobLibraryCacheManager((PermanentBlobService)blobService.getPermanentBlobService(), FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0]), new FileCache(tmInfo.getTmpDirectories(), (PermanentBlobService)blobService.getPermanentBlobService()), (TaskManagerRuntimeInfo)tmInfo, UnregisteredMetricGroups.createUnregisteredTaskMetricGroup(), (ResultPartitionConsumableNotifier)new NoOpResultPartitionConsumableNotifier(), (PartitionProducerStateChecker)new NoOpPartitionProducerStateChecker(), (Executor)executor);
                System.err.println("starting task thread");
                task.startTaskThread();
            }
            catch (Throwable t) {
                System.err.println("ERROR STARTING TASK");
                t.printStackTrace();
            }
            System.err.println("parking the main thread");
            CommonTestUtils.blockForeverNonInterruptibly();
        }

        private static final class NoOpPartitionProducerStateChecker
        implements PartitionProducerStateChecker {
            private NoOpPartitionProducerStateChecker() {
            }

            public CompletableFuture<ExecutionState> requestPartitionProducerState(JobID jobId, IntermediateDataSetID intermediateDataSetId, ResultPartitionID r) {
                return null;
            }
        }

        private static final class NoOpCheckpointResponder
        implements CheckpointResponder {
            private NoOpCheckpointResponder() {
            }

            public void acknowledgeCheckpoint(JobID j, ExecutionAttemptID e, long i, CheckpointMetrics c, TaskStateSnapshot s) {
            }

            public void declineCheckpoint(JobID j, ExecutionAttemptID e, long l, Throwable t) {
            }
        }

        private static final class NoOpInputSplitProvider
        implements InputSplitProvider {
            private NoOpInputSplitProvider() {
            }

            public InputSplit getNextInputSplit(ClassLoader userCodeClassLoader) {
                return null;
            }
        }

        public static final class OomInvokable
        extends AbstractInvokable {
            public OomInvokable(Environment environment) {
                super(environment);
            }

            public void invoke() throws Exception {
                throw new OutOfMemoryError();
            }
        }
    }

    private static final class KillOnFatalErrorProcess
    extends TestJvmProcess {
        @Override
        public String getName() {
            return "KillOnFatalErrorProcess";
        }

        @Override
        public String[] getJvmArgs() {
            return new String[0];
        }

        @Override
        public String getEntryPointClassName() {
            return ProcessEntryPoint.class.getName();
        }
    }
}

