/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.Preconditions;

public class TestingTaskManagerRuntimeInfo
implements TaskManagerRuntimeInfo {
    private final Configuration configuration;
    private final String[] tmpDirectories;

    public TestingTaskManagerRuntimeInfo() {
        this(new Configuration(), System.getProperty("java.io.tmpdir").split(",|" + File.pathSeparator));
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration) {
        this(configuration, EnvironmentInformation.getTemporaryFileDirectory());
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String tmpDirectory) {
        this(configuration, new String[]{(String)Preconditions.checkNotNull((Object)tmpDirectory)});
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String[] tmpDirectories) {
        this.configuration = configuration;
        this.tmpDirectories = tmpDirectories;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }

    public boolean shouldExitJvmOnOutOfMemoryError() {
        return false;
    }
}

