/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.Terminated;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManagerCliOptions;
import org.apache.flink.runtime.jobmanager.JobManagerMode;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.retriever.impl.AkkaJobManagerRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.AkkaQueryServiceRetriever;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.NetUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scopt.OptionParser;
import scopt.Read$;

public final class JobManager$ {
    public static final JobManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;

    static {
        new JobManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        Tuple4 tuple4;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "JobManager", args);
        SignalHandler.register(this.LOG().logger());
        JvmShutdownSafeguard.installAsShutdownHook(this.LOG().logger());
        Tuple4 tuple42 = this.liftedTree1$1(args);
        if (tuple42 == null) throw new MatchError((Object)tuple42);
        Configuration configuration = (Configuration)tuple42._1();
        JobManagerMode executionMode = (JobManagerMode)((Object)tuple42._2());
        String externalHostName = (String)tuple42._3();
        Iterator portRange = (Iterator)tuple42._4();
        if (configuration == null) throw new MatchError((Object)tuple42);
        Configuration configuration2 = configuration;
        if (executionMode == null) throw new MatchError((Object)tuple42);
        JobManagerMode jobManagerMode = executionMode;
        if (externalHostName == null) throw new MatchError((Object)tuple42);
        String string = externalHostName;
        if (portRange == null) throw new MatchError((Object)tuple42);
        Iterator iterator = portRange;
        Tuple4 tuple43 = tuple4 = new Tuple4((Object)configuration2, (Object)jobManagerMode, (Object)string, (Object)iterator);
        Configuration configuration3 = (Configuration)tuple43._1();
        JobManagerMode executionMode2 = (JobManagerMode)((Object)tuple43._2());
        String externalHostName2 = (String)tuple43._3();
        Iterator portRange2 = (Iterator)tuple43._4();
        if (externalHostName2 == null) {
            String message = new StringBuilder().append((Object)"Config parameter '").append((Object)JobManagerOptions.ADDRESS.key()).append((Object)"' is missing (hostname/address to bind JobManager to).").toString();
            this.LOG().error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
        if (!portRange2.hasNext()) {
            if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration3)) {
                String message = "Config parameter 'high-availability.jobmanager.port' does not specify a valid port range.";
                this.LOG().error((Function0)new Serializable(message){
                    public static final long serialVersionUID = 0L;
                    private final String message$2;

                    public final String apply() {
                        return this.message$2;
                    }
                    {
                        this.message$2 = message$2;
                    }
                });
                System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            } else {
                String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config parameter '"})).s((Seq)Nil$.MODULE$)).append((Object)JobManagerOptions.ADDRESS.key()).append((Object)"' does not specify a valid port.").toString();
                this.LOG().error((Function0)new Serializable(message){
                    public static final long serialVersionUID = 0L;
                    private final String message$3;

                    public final String apply() {
                        return this.message$3;
                    }
                    {
                        this.message$3 = message$3;
                    }
                });
                System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            }
        }
        SecurityUtils.install(new SecurityConfiguration(configuration3));
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable<BoxedUnit>(configuration3, executionMode2, externalHostName2, portRange2){
                private final Configuration configuration$1;
                private final JobManagerMode executionMode$1;
                private final String externalHostName$1;
                private final Iterator portRange$1;

                public void call() {
                    JobManager$.MODULE$.runJobManager(this.configuration$1, this.executionMode$1, this.externalHostName$1, this.portRange$1);
                }
                {
                    this.configuration$1 = configuration$1;
                    this.executionMode$1 = executionMode$1;
                    this.externalHostName$1 = externalHostName$1;
                    this.portRange$1 = portRange$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run JobManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$12;

                public final Throwable apply() {
                    return this.t$12;
                }
                {
                    this.t$12 = t$12;
                }
            });
            throwable.printStackTrace();
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runJobManager(Configuration configuration, JobManagerMode executionMode, String listeningAddress, int listeningPort) {
        Void void_;
        Option webMonitorOption;
        Option option;
        int numberProcessors = Hardware.getNumberCPUCores();
        ScheduledExecutorService futureExecutor = Executors.newScheduledThreadPool(numberProcessors, new ExecutorThreadFactory("jobmanager-future"));
        ExecutorService ioExecutor = Executors.newFixedThreadPool(numberProcessors, new ExecutorThreadFactory("jobmanager-io"));
        FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
        ActorSystem jobManagerSystem = this.startActorSystem(configuration, listeningAddress, listeningPort);
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, ioExecutor, HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration));
        metricRegistry.startQueryService(jobManagerSystem, null);
        Tuple4 tuple4 = this.liftedTree2$1(configuration, executionMode, listeningAddress, futureExecutor, ioExecutor, jobManagerSystem, highAvailabilityServices, metricRegistry);
        if (tuple4 == null) throw new MatchError((Object)tuple4);
        Option webMonitorOption2 = option = (webMonitorOption = (Option)tuple4._3());
        Await$.MODULE$.ready((Awaitable)jobManagerSystem.whenTerminated(), (Duration)Duration$.MODULE$.Inf());
        webMonitorOption2.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(WebMonitor webMonitor) {
                try {
                    webMonitor.stop();
                }
                catch (Throwable throwable) {
                    JobManager$.MODULE$.LOG().warn((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Could not properly stop the web monitor.";
                        }
                    }, (Function0)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$13;

                        public final Throwable apply() {
                            return this.t$13;
                        }
                        {
                            this.t$13 = t$13;
                        }
                    });
                }
            }
        });
        try {
            highAvailabilityServices.close();
        }
        catch (Throwable throwable) {
            this.LOG().warn((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not properly stop the high availability services.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$14;

                public final Throwable apply() {
                    return this.t$14;
                }
                {
                    this.t$14 = t$14;
                }
            });
        }
        try {
            void_ = metricRegistry.shutdown().get();
        }
        catch (Throwable throwable) {
            this.LOG().warn((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not properly shut down the metric registry.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$15;

                public final Throwable apply() {
                    return this.t$15;
                }
                {
                    this.t$15 = t$15;
                }
            });
            void_ = BoxedUnit.UNIT;
        }
        ExecutorUtils.gracefulShutdown((long)timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{futureExecutor, ioExecutor});
    }

    public void runJobManager(Configuration configuration, JobManagerMode executionMode, String listeningAddress, Iterator<Integer> listeningPortRange) {
        Try result = AkkaUtils$.MODULE$.retryOnBindException(new Serializable(configuration, executionMode, listeningAddress, listeningPortRange){
            public static final long serialVersionUID = 0L;
            private final Configuration configuration$2;
            private final JobManagerMode executionMode$2;
            private final String listeningAddress$1;
            private final Iterator listeningPortRange$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcV$sp() {
                int n;
                ServerSocket socket = NetUtils.createSocketFromPorts((Iterator)this.listeningPortRange$1, (NetUtils.SocketFactory)new NetUtils.SocketFactory(this){

                    public ServerSocket createSocket(int port) {
                        return new ServerSocket(port, 0, InetAddress.getByName(NetUtils.getWildcardIPAddress()));
                    }
                });
                if (socket == null) {
                    throw new BindException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to allocate port for JobManager."})).s((Seq)Nil$.MODULE$));
                }
                try {
                    n = socket.getLocalPort();
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                socket.close();
                int port = n;
                JobManager$.MODULE$.runJobManager(this.configuration$2, this.executionMode$2, this.listeningAddress$1, port);
            }
            {
                this.configuration$2 = configuration$2;
                this.executionMode$2 = executionMode$2;
                this.listeningAddress$1 = listeningAddress$1;
                this.listeningPortRange$1 = listeningPortRange$1;
            }
        }, (Function0<Object>)new Serializable(listeningPortRange){
            public static final long serialVersionUID = 0L;
            private final Iterator listeningPortRange$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.listeningPortRange$1.hasNext();
            }
            {
                this.listeningPortRange$1 = listeningPortRange$1;
            }
        }, 5000L);
        Try try_ = result;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable f = failure.exception();
            throw f;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ActorSystem startActorSystem(Configuration configuration, String externalHostname, int port) {
        ActorSystem jobManagerSystem = BootstrapTools.startActorSystem(configuration, externalHostname, port, this.LOG().logger());
        Address address = AkkaUtils$.MODULE$.getAddress(jobManagerSystem);
        configuration.setString(JobManagerOptions.ADDRESS, (String)address.host().get());
        configuration.setInteger(JobManagerOptions.PORT, BoxesRunTime.unboxToInt((Object)address.port().get()));
        return jobManagerSystem;
    }

    public Tuple4<ActorRef, ActorRef, Option<WebMonitor>, Option<ActorRef>> startJobManagerActors(ActorSystem jobManagerSystem, Configuration configuration, JobManagerMode executionMode, String externalHostname, ScheduledExecutorService futureExecutor, Executor ioExecutor, HighAvailabilityServices highAvailabilityServices, MetricRegistry metricRegistry, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass, Option<Class<? extends FlinkResourceManager<?>>> resourceManagerClass) {
        None$ none$;
        if (configuration.getInteger(WebOptions.PORT, 0) >= 0) {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager web frontend";
                }
            });
            Time timeout = FutureUtils.toTime(AkkaUtils$.MODULE$.getTimeout(configuration));
            WebMonitor webServer = WebMonitorUtils.startWebRuntimeMonitor(configuration, highAvailabilityServices, new AkkaJobManagerRetriever(jobManagerSystem, timeout, 10, Time.milliseconds((long)50L)), new AkkaQueryServiceRetriever(jobManagerSystem, timeout), timeout, new ScheduledExecutorServiceAdapter(futureExecutor));
            none$ = Option$.MODULE$.apply((Object)webServer);
        } else {
            none$ = None$.MODULE$;
        }
        None$ webMonitor = none$;
        webMonitor.foreach((Function1)new Serializable(configuration){
            public static final long serialVersionUID = 0L;
            private final Configuration configuration$4;

            public final void apply(WebMonitor monitor) {
                this.configuration$4.setInteger(WebOptions.PORT, monitor.getServerPort());
            }
            {
                this.configuration$4 = configuration$4;
            }
        });
        try {
            Tuple2<ActorRef, ActorRef> tuple2;
            block9: {
                Option<Class<? extends FlinkResourceManager<?>>> option;
                block12: {
                    None$ none$2;
                    ActorRef archive;
                    ActorRef jobManager;
                    block11: {
                        block10: {
                            BoxedUnit boxedUnit;
                            Tuple2 tuple22;
                            this.LOG().info((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Starting JobManager actor";
                                }
                            });
                            tuple2 = this.startJobManagerActors(configuration, jobManagerSystem, futureExecutor, ioExecutor, highAvailabilityServices, metricRegistry, (Option<String>)webMonitor.map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(WebMonitor x$3) {
                                    return x$3.getRestAddress();
                                }
                            }), jobManagerClass, archiveClass);
                            if (tuple2 == null) break block9;
                            ActorRef jobManager2 = (ActorRef)tuple2._1();
                            ActorRef archive2 = (ActorRef)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobManager2, (Object)archive2);
                            jobManager = (ActorRef)tuple23._1();
                            archive = (ActorRef)tuple23._2();
                            this.LOG().debug((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Starting JobManager process reaper";
                                }
                            });
                            jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobManager, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "JobManager_Process_Reaper");
                            JobManagerMode jobManagerMode = executionMode;
                            JobManagerMode jobManagerMode2 = JobManagerMode.LOCAL;
                            if (!(jobManagerMode != null ? !((Object)((Object)jobManagerMode)).equals((Object)jobManagerMode2) : jobManagerMode2 != null)) {
                                this.LOG().info((Function0)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Starting embedded TaskManager for JobManager's LOCAL execution mode";
                                    }
                                });
                                ResourceID resourceId = ResourceID.generate();
                                ActorRef taskManagerActor = TaskManager$.MODULE$.startTaskManagerComponentsAndActor(configuration, resourceId, jobManagerSystem, highAvailabilityServices, metricRegistry, externalHostname, (Option<String>)new Some((Object)"taskmanager"), true, TaskManager.class);
                                this.LOG().debug((Function0)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Starting TaskManager process reaper";
                                    }
                                });
                                boxedUnit = jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerActor, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            webMonitor.foreach((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(WebMonitor x$5) {
                                    x$5.start();
                                }
                            });
                            option = resourceManagerClass;
                            if (!(option instanceof Some)) break block10;
                            Some some = (Some)option;
                            Class rmClass = (Class)some.x();
                            this.LOG().debug((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Starting Resource manager actor";
                                }
                            });
                            none$2 = Option$.MODULE$.apply((Object)FlinkResourceManager.startResourceManagerActors(configuration, jobManagerSystem, highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), rmClass));
                            break block11;
                        }
                        if (!None$.MODULE$.equals(option)) break block12;
                        this.LOG().info((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Resource Manager class not provided. No resource manager will be started.";
                            }
                        });
                        none$2 = None$.MODULE$;
                    }
                    None$ resourceManager = none$2;
                    return new Tuple4((Object)jobManager, (Object)archive, (Object)webMonitor, (Object)resourceManager);
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up JobManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$16;

                public final Throwable apply() {
                    return this.t$16;
                }
                {
                    this.t$16 = t$16;
                }
            });
            jobManagerSystem.terminate().onComplete((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Try<Terminated> x0$5) {
                    Try<Terminated> try_;
                    block4: {
                        block3: {
                            block2: {
                                try_ = x0$5;
                                if (!(try_ instanceof Success)) break block2;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(try_ instanceof Failure)) break block4;
                            Failure failure = (Failure)try_;
                            Throwable tt = failure.exception();
                            JobManager$.MODULE$.LOG().warn((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Could not cleanly shut down actor system";
                                }
                            }, (Function0)new Serializable(this, tt){
                                public static final long serialVersionUID = 0L;
                                private final Throwable tt$2;

                                public final Throwable apply() {
                                    return this.tt$2;
                                }
                                {
                                    this.tt$2 = tt$2;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(try_);
                }
            }, org.apache.flink.runtime.concurrent.Executors.directExecutionContext());
            throw throwable;
        }
    }

    public Tuple4<Configuration, JobManagerMode, String, Iterator<Integer>> parseArgs(String[] args) {
        String string;
        Configuration configuration;
        JobManagerCliOptions cliOptions;
        block8: {
            OptionParser<JobManagerCliOptions> parser = new OptionParser<JobManagerCliOptions>(){
                {
                    this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink JobManager"}));
                    this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                            conf.setConfigDir(arg);
                            return conf;
                        }
                    }).text("The configuration directory.");
                    this.opt("executionMode", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                            conf.setJobManagerMode(arg);
                            return conf;
                        }
                    }).text("The execution mode of the JobManager (CLUSTER / LOCAL)");
                    this.opt("host", Read$.MODULE$.stringRead()).optional().action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                            conf.setHost(arg);
                            return conf;
                        }
                    }).text("Network address for communication with the job manager");
                    this.opt("webui-port", Read$.MODULE$.intRead()).optional().action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(int arg, JobManagerCliOptions conf) {
                            conf.setWebUIPort(arg);
                            return conf;
                        }
                    }).text("Port for the UI web server");
                }
            };
            cliOptions = (JobManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new JobManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
                public static final long serialVersionUID = 0L;
                private final String[] args$2;
                private final OptionParser parser$1;

                public final Nothing$ apply() {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line arguments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$2).mkString(" "), this.parser$1.usage()})));
                }
                {
                    this.args$2 = args$2;
                    this.parser$1 = parser$1;
                }
            });
            String configDir = cliOptions.getConfigDir();
            if (configDir == null) {
                throw new Exception("Missing parameter '--configDir'");
            }
            if (cliOptions.getJobManagerMode() == null) {
                throw new Exception("Missing parameter '--executionMode'");
            }
            this.LOG().info((Function0)new Serializable(configDir){
                public static final long serialVersionUID = 0L;
                private final String configDir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.configDir$1).toString();
                }
                {
                    this.configDir$1 = configDir$1;
                }
            });
            configuration = GlobalConfiguration.loadConfiguration((String)configDir);
            try {
                FileSystem.initialize((Configuration)configuration);
                if (cliOptions.getWebUIPort() < 0) break block8;
            }
            catch (IOException iOException) {
                throw new Exception("Error while setting the default filesystem scheme from configuration.", iOException);
            }
            configuration.setInteger(WebOptions.PORT, cliOptions.getWebUIPort());
        }
        if (cliOptions.getHost() != null) {
            configuration.setString(JobManagerOptions.ADDRESS, cliOptions.getHost());
        }
        String host = configuration.getString(JobManagerOptions.ADDRESS);
        if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration)) {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager with high-availability";
                }
            });
            configuration.setInteger(JobManagerOptions.PORT, 0);
            string = configuration.getValue(HighAvailabilityOptions.HA_JOB_MANAGER_PORT_RANGE);
        } else {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager without high-availability";
                }
            });
            int listeningPort = configuration.getInteger(JobManagerOptions.PORT);
            if (listeningPort <= 0 || listeningPort >= 65536) {
                String message = new StringBuilder().append((Object)"Config parameter '").append((Object)JobManagerOptions.PORT.key()).append((Object)"' is invalid, it must be greater than 0 and less than 65536.").toString();
                this.LOG().error((Function0)new Serializable(message){
                    public static final long serialVersionUID = 0L;
                    private final String message$4;

                    public final String apply() {
                        return this.message$4;
                    }
                    {
                        this.message$4 = message$4;
                    }
                });
                System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            }
            string = String.valueOf(listeningPort);
        }
        String portRange = string;
        JobManagerMode executionMode = cliOptions.getJobManagerMode();
        this.LOG().info((Function0)new Serializable(host, portRange, executionMode){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final String portRange$2;
            private final JobManagerMode executionMode$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting JobManager on ", ":", " with execution mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1, this.portRange$2, this.executionMode$4}));
            }
            {
                this.host$1 = host$1;
                this.portRange$2 = portRange$2;
                this.executionMode$4 = executionMode$4;
            }
        });
        Iterator portRangeIterator = NetUtils.getPortRangeFromString((String)portRange);
        return new Tuple4((Object)configuration, (Object)executionMode, (Object)host, (Object)portRangeIterator);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple10<InstanceManager, Scheduler, BlobServer, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, Option<Path>, FiniteDuration, JobManagerMetricGroup> createJobManagerComponents(Configuration configuration, ScheduledExecutorService futureExecutor, Executor ioExecutor, BlobStore blobStore, MetricRegistry metricRegistry) {
        FiniteDuration finiteDuration;
        BlobLibraryCacheManager libraryCacheManager;
        Scheduler scheduler;
        InstanceManager instanceManager;
        BlobServer blobServer;
        Option archivePath;
        int archiveCount;
        RestartStrategyFactory restartStrategy;
        FiniteDuration timeout;
        block13: {
            String jobRecoveryTimeoutStr;
            block12: {
                Option option;
                timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
                String classLoaderResolveOrder = configuration.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
                String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((Configuration)configuration);
                restartStrategy = RestartStrategyFactory.createRestartStrategyFactory(configuration);
                archiveCount = configuration.getInteger(WebOptions.ARCHIVE_COUNT);
                String archiveDir = configuration.getString(JobManagerOptions.ARCHIVE_DIR);
                if (archiveDir == null) {
                    this.LOG().debug((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "No archive directory was configured. Jobs will not be archived.";
                        }
                    });
                    option = Option$.MODULE$.empty();
                } else {
                    try {
                        option = Option$.MODULE$.apply((Object)WebMonitorUtils.validateAndNormalizeUri(new Path(archiveDir).toUri()));
                    }
                    catch (Exception exception) {
                        this.LOG().warn((Function0)new Serializable(archiveDir){
                            public static final long serialVersionUID = 0L;
                            private final String archiveDir$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to validate specified archive directory in '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.archiveDir$1}))).append((Object)"Jobs will not be archived for the HistoryServer.").toString();
                            }
                            {
                                this.archiveDir$1 = archiveDir$1;
                            }
                        }, (Function0)new Serializable(exception){
                            public static final long serialVersionUID = 0L;
                            private final Exception e$9;

                            public final Exception apply() {
                                return this.e$9;
                            }
                            {
                                this.e$9 = e$9;
                            }
                        });
                        option = Option$.MODULE$.empty();
                    }
                }
                archivePath = option;
                blobServer = null;
                instanceManager = null;
                scheduler = null;
                libraryCacheManager = null;
                try {
                    blobServer = new BlobServer(configuration, blobStore);
                    blobServer.start();
                    instanceManager = new InstanceManager();
                    scheduler = new Scheduler((Executor)ExecutionContext$.MODULE$.fromExecutor((Executor)futureExecutor));
                    libraryCacheManager = new BlobLibraryCacheManager(blobServer, FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns);
                    instanceManager.addInstanceListener(scheduler);
                }
                catch (Throwable throwable) {
                    void var14_14;
                    void var17_17;
                    void var15_15;
                    void var16_16;
                    if (var16_16 != null) {
                        var16_16.shutdown();
                    }
                    if (var15_15 != null) {
                        var15_15.shutdown();
                    }
                    if (var17_17 != null) {
                        var17_17.shutdown();
                    }
                    if (var14_14 != null) {
                        var14_14.close();
                    }
                    throw throwable;
                }
                jobRecoveryTimeoutStr = configuration.getValue(HighAvailabilityOptions.HA_JOB_DELAY);
                if (jobRecoveryTimeoutStr != null && !jobRecoveryTimeoutStr.isEmpty()) break block12;
                finiteDuration = timeout;
                break block13;
            }
            try {}
            catch (NumberFormatException numberFormatException) {
                void var18_18;
                throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HighAvailabilityOptions.HA_JOB_DELAY.key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Value must be a valid duration (such as '10 s' or '1 min')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var18_18}))).toString());
            }
            finiteDuration = FiniteDuration$.MODULE$.apply(Duration$.MODULE$.apply(jobRecoveryTimeoutStr).toMillis(), TimeUnit.MILLISECONDS);
        }
        FiniteDuration jobRecoveryTimeout = finiteDuration;
        JobManagerMetricGroup jobManagerMetricGroup = MetricUtils.instantiateJobManagerMetricGroup(metricRegistry, configuration.getString(JobManagerOptions.ADDRESS), ConfigurationUtils.getSystemResourceMetricsProbingInterval((Configuration)configuration));
        return new Tuple10((Object)instanceManager, (Object)scheduler, (Object)blobServer, (Object)libraryCacheManager, (Object)restartStrategy, (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)archivePath, (Object)jobRecoveryTimeout, (Object)jobManagerMetricGroup);
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, ScheduledExecutorService futureExecutor, Executor ioExecutor, HighAvailabilityServices highAvailabilityServices, MetricRegistry metricRegistry, Option<String> optRestAddress, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass) {
        return this.startJobManagerActors(configuration, actorSystem, futureExecutor, ioExecutor, highAvailabilityServices, metricRegistry, optRestAddress, (Option<String>)new Some((Object)"jobmanager"), (Option<String>)new Some((Object)"archive"), jobManagerClass, archiveClass);
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, ScheduledExecutorService futureExecutor, Executor ioExecutor, HighAvailabilityServices highAvailabilityServices, MetricRegistry metricRegistry, Option<String> optRestAddress, Option<String> jobManagerActorName, Option<String> archiveActorName, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass) {
        Tuple10<InstanceManager, Scheduler, BlobServer, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, Option<Path>, FiniteDuration, JobManagerMetricGroup> tuple10;
        block2: {
            Option<String> option;
            block5: {
                Option<String> option2;
                block8: {
                    ActorRef actorRef;
                    ActorRef archive;
                    block7: {
                        Props jobManagerProps;
                        block6: {
                            ActorRef actorRef2;
                            JobManagerMetricGroup jobManagerMetricGroup;
                            FiniteDuration jobRecoveryTimeout;
                            FiniteDuration timeout;
                            RestartStrategyFactory restartStrategy;
                            BlobLibraryCacheManager libraryCacheManager;
                            BlobServer blobServer;
                            Scheduler scheduler;
                            InstanceManager instanceManager;
                            block4: {
                                Props archiveProps;
                                block3: {
                                    Tuple10 tuple102;
                                    tuple10 = this.createJobManagerComponents(configuration, futureExecutor, ioExecutor, highAvailabilityServices.createBlobStore(), metricRegistry);
                                    if (tuple10 == null) break block2;
                                    InstanceManager instanceManager2 = (InstanceManager)tuple10._1();
                                    Scheduler scheduler2 = (Scheduler)tuple10._2();
                                    BlobServer blobServer2 = (BlobServer)tuple10._3();
                                    BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple10._4();
                                    RestartStrategyFactory restartStrategy2 = (RestartStrategyFactory)tuple10._5();
                                    FiniteDuration timeout2 = (FiniteDuration)tuple10._6();
                                    int archiveCount = BoxesRunTime.unboxToInt((Object)tuple10._7());
                                    Option archivePath = (Option)tuple10._8();
                                    FiniteDuration jobRecoveryTimeout2 = (FiniteDuration)tuple10._9();
                                    JobManagerMetricGroup jobManagerMetricGroup2 = (JobManagerMetricGroup)tuple10._10();
                                    Tuple10 tuple103 = tuple102 = new Tuple10((Object)instanceManager2, (Object)scheduler2, (Object)blobServer2, (Object)libraryCacheManager2, (Object)restartStrategy2, (Object)timeout2, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)archivePath, (Object)jobRecoveryTimeout2, (Object)jobManagerMetricGroup2);
                                    instanceManager = (InstanceManager)tuple103._1();
                                    scheduler = (Scheduler)tuple103._2();
                                    blobServer = (BlobServer)tuple103._3();
                                    libraryCacheManager = (BlobLibraryCacheManager)tuple103._4();
                                    restartStrategy = (RestartStrategyFactory)tuple103._5();
                                    timeout = (FiniteDuration)tuple103._6();
                                    int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple103._7());
                                    Option archivePath2 = (Option)tuple103._8();
                                    jobRecoveryTimeout = (FiniteDuration)tuple103._9();
                                    jobManagerMetricGroup = (JobManagerMetricGroup)tuple103._10();
                                    archiveProps = this.getArchiveProps(archiveClass, archiveCount2, (Option<Path>)archivePath2);
                                    option = archiveActorName;
                                    if (!(option instanceof Some)) break block3;
                                    Some some = (Some)option;
                                    String actorName = (String)some.x();
                                    actorRef2 = actorSystem.actorOf(archiveProps, actorName);
                                    break block4;
                                }
                                if (!None$.MODULE$.equals(option)) break block5;
                                actorRef2 = actorSystem.actorOf(archiveProps);
                            }
                            archive = actorRef2;
                            jobManagerProps = this.getJobManagerProps(jobManagerClass, configuration, futureExecutor, ioExecutor, instanceManager, scheduler, blobServer, libraryCacheManager, archive, restartStrategy, timeout, highAvailabilityServices.getJobManagerLeaderElectionService(HighAvailabilityServices.DEFAULT_JOB_ID), highAvailabilityServices.getSubmittedJobGraphStore(), highAvailabilityServices.getCheckpointRecoveryFactory(), jobRecoveryTimeout, jobManagerMetricGroup, optRestAddress);
                            option2 = jobManagerActorName;
                            if (!(option2 instanceof Some)) break block6;
                            Some some = (Some)option2;
                            String actorName = (String)some.x();
                            actorRef = actorSystem.actorOf(jobManagerProps, actorName);
                            break block7;
                        }
                        if (!None$.MODULE$.equals(option2)) break block8;
                        actorRef = actorSystem.actorOf(jobManagerProps);
                    }
                    ActorRef jobManager = actorRef;
                    return new Tuple2((Object)jobManager, (Object)archive);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple10);
    }

    public Props getArchiveProps(Class<? extends MemoryArchivist> archiveClass, int archiveCount, Option<Path> archivePath) {
        return Props$.MODULE$.apply(archiveClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archiveCount), archivePath}));
    }

    public Props getJobManagerProps(Class<? extends JobManager> jobManagerClass, Configuration configuration, ScheduledExecutorService futureExecutor, Executor ioExecutor, InstanceManager instanceManager, Scheduler scheduler, BlobServer blobServer, LibraryCacheManager libraryCacheManager, ActorRef archive, RestartStrategyFactory restartStrategyFactory, FiniteDuration timeout, LeaderElectionService leaderElectionService, SubmittedJobGraphStore submittedJobGraphStore, CheckpointRecoveryFactory checkpointRecoveryFactory, FiniteDuration jobRecoveryTimeout, JobManagerMetricGroup jobManagerMetricGroup, Option<String> optRestAddress) {
        return Props$.MODULE$.apply(jobManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configuration, futureExecutor, ioExecutor, instanceManager, scheduler, blobServer, libraryCacheManager, archive, restartStrategyFactory, timeout, leaderElectionService, submittedJobGraphStore, checkpointRecoveryFactory, jobRecoveryTimeout, jobManagerMetricGroup, optRestAddress}));
    }

    private final Tuple4 liftedTree1$1(String[] args$1) {
        Tuple4<Configuration, JobManagerMode, String, Iterator<Integer>> tuple4;
        try {
            tuple4 = this.parseArgs(args$1);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final String apply() {
                    return this.t$11.getMessage();
                }
                {
                    this.t$11 = t$11;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final Throwable apply() {
                    return this.t$11;
                }
                {
                    this.t$11 = t$11;
                }
            });
            throwable.printStackTrace();
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            tuple4 = null;
        }
        return tuple4;
    }

    private final Tuple4 liftedTree2$1(Configuration configuration$3, JobManagerMode executionMode$3, String listeningAddress$2, ScheduledExecutorService futureExecutor$1, ExecutorService ioExecutor$1, ActorSystem jobManagerSystem$1, HighAvailabilityServices highAvailabilityServices$1, MetricRegistryImpl metricRegistry$1) {
        try {
            return this.startJobManagerActors(jobManagerSystem$1, configuration$3, executionMode$3, listeningAddress$2, futureExecutor$1, ioExecutor$1, highAvailabilityServices$1, metricRegistry$1, JobManager.class, MemoryArchivist.class, Option$.MODULE$.apply(StandaloneResourceManager.class));
        }
        catch (Throwable throwable) {
            futureExecutor$1.shutdownNow();
            ioExecutor$1.shutdownNow();
            throw throwable;
        }
    }

    private JobManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(JobManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
    }
}

