/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.io.network.netty.PartitionProducerStateChecker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.util.Preconditions;

public class JobManagerConnection {
    private final JobID jobID;
    private final ResourceID resourceID;
    private final JobMasterGateway jobMasterGateway;
    private final TaskManagerActions taskManagerActions;
    private final CheckpointResponder checkpointResponder;
    private final LibraryCacheManager libraryCacheManager;
    private final ResultPartitionConsumableNotifier resultPartitionConsumableNotifier;
    private final PartitionProducerStateChecker partitionStateChecker;

    public JobManagerConnection(JobID jobID, ResourceID resourceID, JobMasterGateway jobMasterGateway, TaskManagerActions taskManagerActions, CheckpointResponder checkpointResponder, LibraryCacheManager libraryCacheManager, ResultPartitionConsumableNotifier resultPartitionConsumableNotifier, PartitionProducerStateChecker partitionStateChecker) {
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
        this.jobMasterGateway = (JobMasterGateway)Preconditions.checkNotNull((Object)jobMasterGateway);
        this.taskManagerActions = (TaskManagerActions)Preconditions.checkNotNull((Object)taskManagerActions);
        this.checkpointResponder = (CheckpointResponder)Preconditions.checkNotNull((Object)checkpointResponder);
        this.libraryCacheManager = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.resultPartitionConsumableNotifier = (ResultPartitionConsumableNotifier)Preconditions.checkNotNull((Object)resultPartitionConsumableNotifier);
        this.partitionStateChecker = (PartitionProducerStateChecker)Preconditions.checkNotNull((Object)partitionStateChecker);
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public JobMasterId getJobMasterId() {
        return (JobMasterId)((Object)this.jobMasterGateway.getFencingToken());
    }

    public JobMasterGateway getJobManagerGateway() {
        return this.jobMasterGateway;
    }

    public TaskManagerActions getTaskManagerActions() {
        return this.taskManagerActions;
    }

    public CheckpointResponder getCheckpointResponder() {
        return this.checkpointResponder;
    }

    public LibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    public ResultPartitionConsumableNotifier getResultPartitionConsumableNotifier() {
        return this.resultPartitionConsumableNotifier;
    }

    public PartitionProducerStateChecker getPartitionStateChecker() {
        return this.partitionStateChecker;
    }
}

