/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.CompositeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.scala.typeutils.EitherSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;
import scala.util.Either;

public class ScalaEitherSerializerSnapshot<L, R>
implements TypeSerializerSnapshot<Either<L, R>> {
    private static final int CURRENT_VERSION = 1;
    private CompositeSerializerSnapshot nestedLeftRightSerializerSnapshot;

    public ScalaEitherSerializerSnapshot() {
    }

    public ScalaEitherSerializerSnapshot(TypeSerializer<L> leftSerializer, TypeSerializer<R> rightSerializer) {
        Preconditions.checkNotNull(leftSerializer);
        Preconditions.checkNotNull(rightSerializer);
        this.nestedLeftRightSerializerSnapshot = new CompositeSerializerSnapshot(new TypeSerializer[]{leftSerializer, rightSerializer});
    }

    public int getCurrentVersion() {
        return 1;
    }

    public TypeSerializer<Either<L, R>> restoreSerializer() {
        return new EitherSerializer(this.nestedLeftRightSerializerSnapshot.getRestoreSerializer(0), this.nestedLeftRightSerializerSnapshot.getRestoreSerializer(1));
    }

    public TypeSerializerSchemaCompatibility<Either<L, R>> resolveSchemaCompatibility(TypeSerializer<Either<L, R>> newSerializer) {
        Preconditions.checkState((this.nestedLeftRightSerializerSnapshot != null ? 1 : 0) != 0);
        if (newSerializer instanceof EitherSerializer) {
            EitherSerializer serializer = (EitherSerializer)newSerializer;
            return this.nestedLeftRightSerializerSnapshot.resolveCompatibilityWithNested(TypeSerializerSchemaCompatibility.compatibleAsIs(), new TypeSerializer[]{serializer.getLeftSerializer(), serializer.getRightSerializer()});
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        this.nestedLeftRightSerializerSnapshot.writeCompositeSnapshot(out);
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.nestedLeftRightSerializerSnapshot = CompositeSerializerSnapshot.readCompositeSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }
}

