/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftFlumeEvent
implements TBase<ThriftFlumeEvent, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ThriftFlumeEvent");
    private static final TField HEADERS_FIELD_DESC = new TField("headers", 13, 1);
    private static final TField BODY_FIELD_DESC = new TField("body", 11, 2);
    public Map<String, String> headers;
    public ByteBuffer body;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ThriftFlumeEvent() {
    }

    public ThriftFlumeEvent(Map<String, String> headers, ByteBuffer body) {
        this();
        this.headers = headers;
        this.body = body;
    }

    public ThriftFlumeEvent(ThriftFlumeEvent other) {
        if (other.isSetHeaders()) {
            HashMap<String, String> __this__headers = new HashMap<String, String>();
            for (Map.Entry<String, String> other_element : other.headers.entrySet()) {
                String other_element_key = other_element.getKey();
                String other_element_value = other_element.getValue();
                String __this__headers_copy_key = other_element_key;
                String __this__headers_copy_value = other_element_value;
                __this__headers.put(__this__headers_copy_key, __this__headers_copy_value);
            }
            this.headers = __this__headers;
        }
        if (other.isSetBody()) {
            this.body = TBaseHelper.copyBinary((ByteBuffer)other.body);
        }
    }

    public ThriftFlumeEvent deepCopy() {
        return new ThriftFlumeEvent(this);
    }

    public void clear() {
        this.headers = null;
        this.body = null;
    }

    public int getHeadersSize() {
        return this.headers == null ? 0 : this.headers.size();
    }

    public void putToHeaders(String key, String val) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, val);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ThriftFlumeEvent setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public void unsetHeaders() {
        this.headers = null;
    }

    public boolean isSetHeaders() {
        return this.headers != null;
    }

    public void setHeadersIsSet(boolean value) {
        if (!value) {
            this.headers = null;
        }
    }

    public byte[] getBody() {
        this.setBody(TBaseHelper.rightSize((ByteBuffer)this.body));
        return this.body == null ? null : this.body.array();
    }

    public ByteBuffer bufferForBody() {
        return this.body;
    }

    public ThriftFlumeEvent setBody(byte[] body) {
        this.setBody(body == null ? (ByteBuffer)null : ByteBuffer.wrap(body));
        return this;
    }

    public ThriftFlumeEvent setBody(ByteBuffer body) {
        this.body = body;
        return this;
    }

    public void unsetBody() {
        this.body = null;
    }

    public boolean isSetBody() {
        return this.body != null;
    }

    public void setBodyIsSet(boolean value) {
        if (!value) {
            this.body = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case HEADERS: {
                if (value == null) {
                    this.unsetHeaders();
                    break;
                }
                this.setHeaders((Map)value);
                break;
            }
            case BODY: {
                if (value == null) {
                    this.unsetBody();
                    break;
                }
                this.setBody((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case HEADERS: {
                return this.getHeaders();
            }
            case BODY: {
                return this.getBody();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case HEADERS: {
                return this.isSetHeaders();
            }
            case BODY: {
                return this.isSetBody();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ThriftFlumeEvent) {
            return this.equals((ThriftFlumeEvent)that);
        }
        return false;
    }

    public boolean equals(ThriftFlumeEvent that) {
        if (that == null) {
            return false;
        }
        boolean this_present_headers = this.isSetHeaders();
        boolean that_present_headers = that.isSetHeaders();
        if (this_present_headers || that_present_headers) {
            if (!this_present_headers || !that_present_headers) {
                return false;
            }
            if (!this.headers.equals(that.headers)) {
                return false;
            }
        }
        boolean this_present_body = this.isSetBody();
        boolean that_present_body = that.isSetBody();
        if (this_present_body || that_present_body) {
            if (!this_present_body || !that_present_body) {
                return false;
            }
            if (!this.body.equals(that.body)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_headers = this.isSetHeaders();
        builder.append(present_headers);
        if (present_headers) {
            builder.append(this.headers);
        }
        boolean present_body = this.isSetBody();
        builder.append(present_body);
        if (present_body) {
            builder.append((Object)this.body);
        }
        return builder.toHashCode();
    }

    public int compareTo(ThriftFlumeEvent other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        ThriftFlumeEvent typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetHeaders()).compareTo(typedOther.isSetHeaders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHeaders() && (lastComparison = TBaseHelper.compareTo(this.headers, typedOther.headers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBody()).compareTo(typedOther.isSetBody());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBody() && (lastComparison = TBaseHelper.compareTo((Comparable)this.body, (Comparable)typedOther.body)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 13) {
                        TMap _map0 = iprot.readMapBegin();
                        this.headers = new HashMap<String, String>(2 * _map0.size);
                        for (int _i1 = 0; _i1 < _map0.size; ++_i1) {
                            String _key2 = iprot.readString();
                            String _val3 = iprot.readString();
                            this.headers.put(_key2, _val3);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.body = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.headers != null) {
            oprot.writeFieldBegin(HEADERS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.headers.size()));
            for (Map.Entry<String, String> _iter4 : this.headers.entrySet()) {
                oprot.writeString(_iter4.getKey());
                oprot.writeString(_iter4.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.body != null) {
            oprot.writeFieldBegin(BODY_FIELD_DESC);
            oprot.writeBinary(this.body);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThriftFlumeEvent(");
        boolean first = true;
        sb.append("headers:");
        if (this.headers == null) {
            sb.append("null");
        } else {
            sb.append(this.headers);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("body:");
        if (this.body == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.body, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.headers == null) {
            throw new TProtocolException("Required field 'headers' was not present! Struct: " + this.toString());
        }
        if (this.body == null) {
            throw new TProtocolException("Required field 'body' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.HEADERS, new FieldMetaData("headers", 1, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.BODY, new FieldMetaData("body", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ThriftFlumeEvent.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        HEADERS(1, "headers"),
        BODY(2, "body");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return HEADERS;
                }
                case 2: {
                    return BODY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

