/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestWebHDFSForHA {
    private static final String LOGICAL_NAME = "minidfs";
    private static final URI WEBHDFS_URI = URI.create("webhdfs://minidfs");
    private static final MiniDFSNNTopology topo = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("minidfs").addNN(new MiniDFSNNTopology.NNConf("nn1")).addNN(new MiniDFSNNTopology.NNConf("nn2")));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHA() throws IOException {
        Configuration conf = DFSTestUtil.newHAConfiguration(LOGICAL_NAME);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(topo).numDataNodes(0).build();
            HATestUtil.setFailoverConfigurations(cluster, conf, LOGICAL_NAME);
            cluster.waitActive();
            fs = FileSystem.get((URI)WEBHDFS_URI, (Configuration)conf);
            cluster.transitionToActive(0);
            Path dir = new Path("/test");
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            cluster.shutdownNameNode(0);
            cluster.transitionToActive(1);
            Path dir2 = new Path("/test2");
            Assert.assertTrue((boolean)fs.mkdirs(dir2));
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecureHAToken() throws IOException, InterruptedException {
        Configuration conf = DFSTestUtil.newHAConfiguration(LOGICAL_NAME);
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        MiniDFSCluster cluster = null;
        WebHdfsFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(topo).numDataNodes(0).build();
            HATestUtil.setFailoverConfigurations(cluster, conf, LOGICAL_NAME);
            cluster.waitActive();
            fs = (WebHdfsFileSystem)Mockito.spy((Object)((WebHdfsFileSystem)FileSystem.get((URI)WEBHDFS_URI, (Configuration)conf)));
            FileSystemTestHelper.addFileSystemForTesting((URI)WEBHDFS_URI, (Configuration)conf, (FileSystem)fs);
            cluster.transitionToActive(0);
            Token token = fs.getDelegationToken(null);
            cluster.shutdownNameNode(0);
            cluster.transitionToActive(1);
            token.renew(conf);
            token.cancel(conf);
            ((WebHdfsFileSystem)Mockito.verify((Object)fs)).renewDelegationToken(token);
            ((WebHdfsFileSystem)Mockito.verify((Object)fs)).cancelDelegationToken(token);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailoverAfterOpen() throws IOException {
        Configuration conf = DFSTestUtil.newHAConfiguration(LOGICAL_NAME);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        Path p = new Path("/test");
        byte[] data = "Hello".getBytes();
        try {
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(topo).numDataNodes(1).build();
            HATestUtil.setFailoverConfigurations(cluster, conf, LOGICAL_NAME);
            cluster.waitActive();
            fs = FileSystem.get((URI)WEBHDFS_URI, (Configuration)conf);
            cluster.transitionToActive(1);
            FSDataOutputStream out = fs.create(p);
            cluster.shutdownNameNode(1);
            cluster.transitionToActive(0);
            out.write(data);
            out.close();
            FSDataInputStream in = fs.open(p);
            byte[] buf = new byte[data.length];
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
            Assert.assertArrayEquals((byte[])data, (byte[])buf);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }
}

