/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ReplicaAccessor;
import org.apache.hadoop.hdfs.ReplicaAccessorBuilder;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestExternalBlockReader {
    private static final Log LOG = LogFactory.getLog(TestExternalBlockReader.class);
    private static long SEED = 1234L;
    private static final String SYNTHETIC_BLOCK_READER_TEST_UUID_KEY = "synthetic.block.reader.test.uuid.key";
    private static final HashMap<String, LinkedList<SyntheticReplicaAccessor>> accessors = new HashMap(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMisconfiguredExternalBlockReader() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.client.replica.accessor.builder.classes", "org.apache.hadoop.hdfs.NonExistentReplicaAccessorBuilderClass");
        conf.setLong("dfs.blocksize", 1024L);
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        int TEST_LENGTH = 2048;
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/a"), 2048L, (short)1, SEED);
            FSDataInputStream stream = dfs.open(new Path("/a"));
            byte[] buf = new byte[2048];
            IOUtils.readFully((InputStream)stream, (byte[])buf, (int)0, (int)2048);
            byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(SEED, 2048);
            Assert.assertArrayEquals((byte[])expected, (byte[])buf);
            stream.close();
        }
        finally {
            dfs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalBlockReader() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.client.replica.accessor.builder.classes", SyntheticReplicaAccessorBuilder.class.getName());
        conf.setLong("dfs.blocksize", 1024L);
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        String uuid = UUID.randomUUID().toString();
        conf.set(SYNTHETIC_BLOCK_READER_TEST_UUID_KEY, uuid);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        int TEST_LENGTH = 2047;
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/a"), 2047L, (short)1, SEED);
            HdfsDataInputStream stream = (HdfsDataInputStream)dfs.open(new Path("/a"));
            byte[] buf = new byte[2047];
            stream.seek(1000L);
            IOUtils.readFully((InputStream)stream, (byte[])buf, (int)1000, (int)1047);
            stream.seek(0L);
            IOUtils.readFully((InputStream)stream, (byte[])buf, (int)0, (int)1000);
            byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(SEED, 2047);
            DFSInputStream.ReadStatistics stats = stream.getReadStatistics();
            Assert.assertEquals((long)1024L, (long)stats.getTotalShortCircuitBytesRead());
            Assert.assertEquals((long)2047L, (long)stats.getTotalLocalBytesRead());
            Assert.assertEquals((long)2047L, (long)stats.getTotalBytesRead());
            Assert.assertArrayEquals((byte[])expected, (byte[])buf);
            stream.close();
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)dfs, new Path("/a"));
            Assert.assertNotNull((Object)block);
            LinkedList<SyntheticReplicaAccessor> accessorList = accessors.get(uuid);
            Assert.assertNotNull(accessorList);
            Assert.assertEquals((long)3L, (long)accessorList.size());
            SyntheticReplicaAccessor accessor = accessorList.get(0);
            Assert.assertTrue((boolean)accessor.builder.allowShortCircuit);
            Assert.assertEquals((Object)block.getBlockPoolId(), (Object)accessor.builder.blockPoolId);
            Assert.assertEquals((long)block.getBlockId(), (long)accessor.builder.blockId);
            Assert.assertEquals((Object)dfs.getClient().clientName, (Object)accessor.builder.clientName);
            Assert.assertEquals((Object)"/a", (Object)accessor.builder.fileName);
            Assert.assertEquals((long)block.getGenerationStamp(), (long)accessor.getGenerationStamp());
            Assert.assertTrue((boolean)accessor.builder.verifyChecksum);
            Assert.assertEquals((long)1024L, (long)accessor.builder.visibleLength);
            Assert.assertEquals((long)24L, (long)accessor.totalRead);
            Assert.assertEquals((Object)"", (Object)accessor.getError());
            Assert.assertEquals((long)1L, (long)accessor.numCloses);
            byte[] tempBuf = new byte[5];
            Assert.assertEquals((long)-1L, (long)accessor.read(2047L, tempBuf, 0, 0));
            Assert.assertEquals((long)-1L, (long)accessor.read(2047L, tempBuf, 0, tempBuf.length));
            accessors.remove(uuid);
        }
        finally {
            dfs.close();
            cluster.shutdown();
        }
    }

    public static class SyntheticReplicaAccessor
    extends ReplicaAccessor {
        final long length;
        final byte[] contents;
        final SyntheticReplicaAccessorBuilder builder;
        long totalRead = 0L;
        int numCloses = 0;
        String error = "";
        String prefix = "";
        final long genstamp;

        SyntheticReplicaAccessor(SyntheticReplicaAccessorBuilder builder) {
            this.length = builder.visibleLength;
            this.contents = DFSTestUtil.calculateFileContentsFromSeed(SEED, Ints.checkedCast((long)this.length));
            this.builder = builder;
            this.genstamp = builder.genstamp;
            String uuid = this.builder.conf.get(TestExternalBlockReader.SYNTHETIC_BLOCK_READER_TEST_UUID_KEY);
            LinkedList<SyntheticReplicaAccessor> accessorsList = (LinkedList<SyntheticReplicaAccessor>)accessors.get(uuid);
            if (accessorsList == null) {
                accessorsList = new LinkedList<SyntheticReplicaAccessor>();
            }
            accessorsList.add(this);
            accessors.put(uuid, accessorsList);
        }

        public synchronized int read(long pos, byte[] buf, int off, int len) throws IOException {
            int ipos;
            if (pos > Integer.MAX_VALUE) {
                return 0;
            }
            if (pos < 0L) {
                this.addError("Attempted to read from a location that was less than 0 at " + pos);
                return 0;
            }
            int i = off;
            int nread = 0;
            for (ipos = (int)pos; ipos < this.contents.length && nread < len; ++ipos) {
                buf[i++] = this.contents[ipos];
                ++this.totalRead;
                LOG.info((Object)("ipos = " + ipos + ", contents.length = " + this.contents.length + ", nread = " + ++nread + ", len = " + len));
            }
            if (nread == 0 && ipos >= this.contents.length) {
                return -1;
            }
            return nread;
        }

        public synchronized int read(long pos, ByteBuffer buf) throws IOException {
            int ipos;
            if (pos > Integer.MAX_VALUE) {
                return 0;
            }
            if (pos < 0L) {
                this.addError("Attempted to read from a location that was less than 0 at " + pos);
                return 0;
            }
            boolean i = false;
            int nread = 0;
            for (ipos = (int)pos; ipos < this.contents.length; ++ipos) {
                try {
                    buf.put(this.contents[ipos]);
                }
                catch (BufferOverflowException bos) {
                    break;
                }
                ++nread;
                ++this.totalRead;
            }
            if (nread == 0 && ipos >= this.contents.length) {
                return -1;
            }
            return nread;
        }

        public synchronized void close() throws IOException {
            ++this.numCloses;
        }

        public boolean isLocal() {
            return true;
        }

        public boolean isShortCircuit() {
            return true;
        }

        synchronized String getError() {
            return this.error;
        }

        long getGenerationStamp() {
            return this.genstamp;
        }

        synchronized void addError(String text) {
            LOG.error((Object)("SyntheticReplicaAccessor error: " + text));
            this.error = this.error + this.prefix + text;
            this.prefix = "; ";
        }
    }

    public static class SyntheticReplicaAccessorBuilder
    extends ReplicaAccessorBuilder {
        String fileName;
        long blockId;
        String blockPoolId;
        long genstamp;
        boolean verifyChecksum;
        String clientName;
        boolean allowShortCircuit;
        long visibleLength;
        Configuration conf;

        public ReplicaAccessorBuilder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public ReplicaAccessorBuilder setBlock(long blockId, String blockPoolId) {
            this.blockId = blockId;
            this.blockPoolId = blockPoolId;
            return this;
        }

        public ReplicaAccessorBuilder setGenerationStamp(long genstamp) {
            this.genstamp = genstamp;
            return this;
        }

        public ReplicaAccessorBuilder setVerifyChecksum(boolean verifyChecksum) {
            this.verifyChecksum = verifyChecksum;
            return this;
        }

        public ReplicaAccessorBuilder setClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public ReplicaAccessorBuilder setAllowShortCircuitReads(boolean allowShortCircuit) {
            this.allowShortCircuit = allowShortCircuit;
            return this;
        }

        public ReplicaAccessorBuilder setVisibleLength(long visibleLength) {
            this.visibleLength = visibleLength;
            return this;
        }

        public ReplicaAccessorBuilder setConfiguration(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ReplicaAccessorBuilder setBlockAccessToken(byte[] token) {
            return this;
        }

        public ReplicaAccessor build() {
            if (this.visibleLength < 1024L) {
                LOG.info((Object)("SyntheticReplicaAccessorFactory returning null for a smaller replica with size " + this.visibleLength));
                return null;
            }
            return new SyntheticReplicaAccessor(this);
        }
    }
}

