/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFetchImage {
    private static final File FETCHED_IMAGE_FILE = new File(System.getProperty("test.build.dir"), "target/fetched-image-dir");
    private static final Pattern IMAGE_REGEX = Pattern.compile("fsimage_(\\d+)");
    private MiniDFSCluster cluster;
    private NameNode nn0 = null;
    private NameNode nn1 = null;
    private Configuration conf = null;

    @BeforeClass
    public static void setupImageDir() {
        FETCHED_IMAGE_FILE.mkdirs();
    }

    @AfterClass
    public static void cleanup() {
        FileUtil.fullyDelete((File)FETCHED_IMAGE_FILE);
    }

    @Before
    public void setupCluster() throws IOException, URISyntaxException {
        this.conf = new Configuration();
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.ha.tail-edits.period", 1);
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        HATestUtil.configureFailoverFs(this.cluster, this.conf);
        this.cluster.waitActive();
    }

    @Test(timeout=30000L)
    public void testFetchImageHA() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        int nnIndex = 0;
        this.cluster.transitionToActive(nnIndex);
        this.testFetchImageInternal(nnIndex, new Path(parent, "dir1"), new Path(parent, "dir2"));
        nnIndex = 1;
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.cluster.transitionToActive(nnIndex);
        this.testFetchImageInternal(nnIndex, new Path(parent, "dir3"), new Path(parent, "dir4"));
    }

    private void testFetchImageInternal(int nnIndex, Path dir1, Path dir2) throws Exception {
        Configuration dfsConf = this.cluster.getConfiguration(nnIndex);
        DFSAdmin dfsAdmin = new DFSAdmin();
        dfsAdmin.setConf(dfsConf);
        try (DistributedFileSystem fs = this.cluster.getFileSystem(nnIndex);){
            TestFetchImage.runFetchImage(dfsAdmin, this.cluster);
            fs.mkdirs(dir1);
            fs.mkdirs(dir2);
            this.cluster.getNameNodeRpc(nnIndex).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            this.cluster.getNameNodeRpc(nnIndex).saveNamespace();
            this.cluster.getNameNodeRpc(nnIndex).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            TestFetchImage.runFetchImage(dfsAdmin, this.cluster);
        }
    }

    private static void runFetchImage(DFSAdmin dfsAdmin, MiniDFSCluster cluster) throws Exception {
        int retVal = dfsAdmin.run(new String[]{"-fetchImage", FETCHED_IMAGE_FILE.getPath()});
        Assert.assertEquals((long)0L, (long)retVal);
        File highestImageOnNn = TestFetchImage.getHighestFsImageOnCluster(cluster);
        MD5Hash expected = MD5FileUtils.computeMd5ForFile((File)highestImageOnNn);
        MD5Hash actual = MD5FileUtils.computeMd5ForFile((File)new File(FETCHED_IMAGE_FILE, highestImageOnNn.getName()));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static File getHighestFsImageOnCluster(MiniDFSCluster cluster) {
        long highestImageTxId = -1L;
        File highestImageOnNn = null;
        for (URI nameDir : cluster.getNameDirs(0)) {
            for (File imageFile : new File(new File(nameDir), "current").listFiles()) {
                long imageTxId;
                Matcher imageMatch = IMAGE_REGEX.matcher(imageFile.getName());
                if (!imageMatch.matches() || (imageTxId = Long.parseLong(imageMatch.group(1))) <= highestImageTxId) continue;
                highestImageTxId = imageTxId;
                highestImageOnNn = imageFile;
            }
        }
        return highestImageOnNn;
    }
}

