/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReportLeaseManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostSet;
import org.apache.hadoop.hdfs.server.blockmanagement.UnresolvedTopologyException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.util.Shell;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDatanodeManager {
    public static final Log LOG = LogFactory.getLog(TestDatanodeManager.class);
    final int NUM_ITERATIONS = 500;

    private static DatanodeManager mockDatanodeManager(FSNamesystem fsn, Configuration conf) throws IOException {
        BlockManager bm = (BlockManager)Mockito.mock(BlockManager.class);
        BlockReportLeaseManager blm = new BlockReportLeaseManager(conf);
        Mockito.when((Object)bm.getBlockReportLeaseManager()).thenReturn((Object)blm);
        DatanodeManager dm = new DatanodeManager(bm, (Namesystem)fsn, conf);
        return dm;
    }

    private static InetSocketAddress entry(String host) {
        return HostFileManager.parseEntry((String)"dummy", (String)"dummy", (String)host);
    }

    @Test
    public void testNumVersionsCorrectAfterReregister() throws IOException, InterruptedException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Configuration conf = new Configuration();
        conf.setLong("dfs.heartbeat.interval", 0L);
        conf.setLong("dfs.namenode.heartbeat.recheck-interval", 10L);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, conf);
        String storageID = "someStorageID1";
        String ip = "someIP" + storageID;
        for (int i = 0; i <= 1; ++i) {
            dm.registerDatanode(new DatanodeRegistration(new DatanodeID(ip, "", storageID, 9000, 0, 0, 0), null, null, "version" + i));
            if (i != 0) continue;
            Thread.sleep(25L);
        }
        HashMap mapToCheck = dm.getDatanodesSoftwareVersions();
        Assert.assertNull((String)"should be no more version0 nodes", mapToCheck.get("version0"));
        Assert.assertEquals((String)"should be one version1 node", (long)((Integer)mapToCheck.get("version1")).intValue(), (long)1L);
    }

    @Test
    public void testNumVersionsReportedCorrect() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, new Configuration());
        Random rng = new Random();
        int seed = rng.nextInt();
        rng = new Random(seed);
        LOG.info((Object)("Using seed " + seed + " for testing"));
        HashMap<String, DatanodeRegistration> sIdToDnReg = new HashMap<String, DatanodeRegistration>();
        for (int i = 0; i < 500; ++i) {
            if (rng.nextBoolean() && i % 3 == 0 && sIdToDnReg.size() != 0) {
                int randomIndex = rng.nextInt() % sIdToDnReg.size();
                Iterator it = sIdToDnReg.entrySet().iterator();
                for (int j = 0; j < randomIndex - 1; ++j) {
                    it.next();
                }
                DatanodeRegistration toRemove = (DatanodeRegistration)it.next().getValue();
                LOG.info((Object)("Removing node " + toRemove.getDatanodeUuid() + " ip " + toRemove.getXferAddr() + " version : " + toRemove.getSoftwareVersion()));
                dm.removeDatanode((DatanodeID)toRemove);
                it.remove();
            } else {
                String storageID = "someStorageID" + rng.nextInt(5000);
                DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
                Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
                if (sIdToDnReg.containsKey(storageID)) {
                    dr = (DatanodeRegistration)sIdToDnReg.get(storageID);
                    if (rng.nextBoolean()) {
                        dr.setIpAddr(dr.getIpAddr() + "newIP");
                    }
                } else {
                    String ip = "someIP" + storageID;
                    Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
                    Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
                    Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
                }
                Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)("version" + rng.nextInt(5)));
                LOG.info((Object)("Registering node storageID: " + dr.getDatanodeUuid() + ", version: " + dr.getSoftwareVersion() + ", IP address: " + dr.getXferAddr()));
                dm.registerDatanode(dr);
                sIdToDnReg.put(storageID, dr);
            }
            HashMap mapToCheck = dm.getDatanodesSoftwareVersions();
            for (Map.Entry it : sIdToDnReg.entrySet()) {
                String ver = ((DatanodeRegistration)it.getValue()).getSoftwareVersion();
                if (!mapToCheck.containsKey(ver)) {
                    throw new AssertionError((Object)("The correct number of datanodes of a version was not found on iteration " + i));
                }
                mapToCheck.put(ver, (Integer)mapToCheck.get(ver) - 1);
                if ((Integer)mapToCheck.get(ver) != 0) continue;
                mapToCheck.remove(ver);
            }
            for (Map.Entry entry : mapToCheck.entrySet()) {
                LOG.info((Object)("Still in map: " + (String)entry.getKey() + " has " + entry.getValue()));
            }
            Assert.assertEquals((String)("The map of version counts returned by DatanodeManager was not what it was expected to be on iteration " + i), (long)0L, (long)mapToCheck.size());
        }
    }

    @Test(timeout=100000L)
    public void testRejectUnresolvedDatanodes() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.reject-unresolved-dn-topology-mapping", true);
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, conf);
        String storageID = "someStorageID-123";
        DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
        Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
        try {
            dm.registerDatanode(dr);
            Assert.fail((String)"Expected an UnresolvedTopologyException");
        }
        catch (UnresolvedTopologyException ute) {
            LOG.info((Object)"Expected - topology is not resolved and registration is rejected.");
        }
        catch (Exception e) {
            Assert.fail((String)"Expected an UnresolvedTopologyException");
        }
    }

    @Test
    public void testSortLocatedBlocks() throws IOException, URISyntaxException {
        this.HelperFunction(null);
    }

    @Test
    public void testgoodScript() throws IOException, URISyntaxException {
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-script"));
    }

    @Test
    public void testBadScript() throws IOException, URISyntaxException {
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-broken-script"));
    }

    public void HelperFunction(String scriptFileName) throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        if (scriptFileName != null && !scriptFileName.isEmpty()) {
            URL shellScript = this.getClass().getResource(scriptFileName);
            Path resourcePath = Paths.get(shellScript.toURI());
            FileUtil.setExecutable((File)resourcePath.toFile(), (boolean)true);
            conf.set("net.topology.script.file.name", resourcePath.toString());
        }
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, conf);
        DatanodeInfo[] locs = new DatanodeInfo[5];
        String[] storageIDs = new String[5];
        StorageType[] storageTypes = new StorageType[]{StorageType.ARCHIVE, StorageType.DEFAULT, StorageType.DISK, StorageType.RAM_DISK, StorageType.SSD};
        for (int i = 0; i < 5; ++i) {
            String uuid = "UUID-" + i;
            String ip = "IP-" + i;
            DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)uuid);
            Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
            Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
            Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
            Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)"version1");
            dm.registerDatanode(dr);
            locs[i] = dm.getDatanode(uuid);
            storageIDs[i] = "storageID-" + i;
        }
        locs[0].setDecommissioned();
        locs[1].setDecommissioned();
        ExtendedBlock b = new ExtendedBlock("somePoolID", 1234L);
        LocatedBlock block = new LocatedBlock(b, locs, storageIDs, storageTypes);
        ArrayList<LocatedBlock> blocks = new ArrayList<LocatedBlock>();
        blocks.add(block);
        String targetIp = locs[4].getIpAddr();
        dm.sortLocatedBlocks(targetIp, blocks);
        DatanodeInfo[] sortedLocs = block.getLocations();
        storageIDs = block.getStorageIDs();
        storageTypes = block.getStorageTypes();
        Assert.assertThat((Object)sortedLocs.length, (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)storageIDs.length, (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)storageTypes.length, (Matcher)Is.is((Object)5));
        for (int i = 0; i < sortedLocs.length; ++i) {
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageID(), (Matcher)Is.is((Object)storageIDs[i]));
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageType(), (Matcher)Is.is((Object)storageTypes[i]));
        }
        Assert.assertThat((Object)sortedLocs[0].getIpAddr(), (Matcher)Is.is((Object)targetIp));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 1].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 2].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
    }

    @Test
    public void testRemoveIncludedNode() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, new Configuration());
        HostFileManager hm = new HostFileManager();
        HostSet noNodes = new HostSet();
        HostSet oneNode = new HostSet();
        HostSet twoNodes = new HostSet();
        DatanodeRegistration dr1 = new DatanodeRegistration(new DatanodeID("127.0.0.1", "127.0.0.1", "someStorageID-123", 12345, 12345, 12345, 12345), new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), "test");
        DatanodeRegistration dr2 = new DatanodeRegistration(new DatanodeID("127.0.0.1", "127.0.0.1", "someStorageID-234", 23456, 23456, 23456, 23456), new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), "test");
        twoNodes.add(TestDatanodeManager.entry("127.0.0.1:12345"));
        twoNodes.add(TestDatanodeManager.entry("127.0.0.1:23456"));
        oneNode.add(TestDatanodeManager.entry("127.0.0.1:23456"));
        hm.refresh(twoNodes, noNodes);
        Whitebox.setInternalState((Object)dm, (String)"hostConfigManager", (Object)hm);
        dm.registerDatanode(dr1);
        dm.registerDatanode(dr2);
        List both = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        Collections.sort(both);
        Assert.assertEquals((String)"Incorrect number of hosts reported", (long)2L, (long)both.size());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:12345", (Object)((DatanodeDescriptor)both.get(0)).getInfoAddr());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:23456", (Object)((DatanodeDescriptor)both.get(1)).getInfoAddr());
        hm.refresh(oneNode, noNodes);
        List onlyOne = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        Assert.assertEquals((String)"Incorrect number of hosts reported", (long)1L, (long)onlyOne.size());
        Assert.assertEquals((String)"Unexpected host reported", (Object)"127.0.0.1:23456", (Object)((DatanodeDescriptor)onlyOne.get(0)).getInfoAddr());
        hm.refresh(noNodes, noNodes);
        List bothAgain = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        Collections.sort(bothAgain);
        Assert.assertEquals((String)"Incorrect number of hosts reported", (long)2L, (long)bothAgain.size());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:12345", (Object)((DatanodeDescriptor)bothAgain.get(0)).getInfoAddr());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:23456", (Object)((DatanodeDescriptor)bothAgain.get(1)).getInfoAddr());
    }

    public static class MyResolver
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return null;
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

